<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('new-layout'); ?>

    <!-- Main Start -->
    <div class="optech-breadcrumb"
        style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
        <div class="container">
            <h1 class="post__title"><?php echo e(__('translate.Contact Us')); ?></h1>
            <nav class="breadcrumbs">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                    <li aria-current="page"> <?php echo e(__('translate.Contact Us')); ?></li>
                </ul>
            </nav>

        </div>
    </div>
    <!-- End breadcrumb -->

    <div class="section optech-section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 d-flex align-items-center">
                    <div class="optech-default-content mr40">
                        <h2><?php echo e($contact_us->title); ?></h2>
                        <p><?php echo e($contact_us->description); ?></p>
                        <div class="optech-contact-info-column">
                            <div class="optech-contact-info">
                                <i class="ri-map-pin-2-fill"></i>
                                <h5><?php echo e(__('translate.Address')); ?></h5>
                                <p> <?php echo e(Str::limit($contact_us->address, 20)); ?> </p>
                            </div>
                            <div class="optech-contact-info">
                                <i class="ri-mail-fill"></i>
                                <h5><?php echo e(__('translate.Contact')); ?></h5>
                                <a href="mailto:<?php echo e($contact_us->email); ?>"><?php echo e($contact_us->email); ?></a>
                                <a href="tel:<?php echo e($contact_us->phone); ?>"><?php echo e($contact_us->phone); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="optech-main-form bg-light1 ml60" data-aos="fade-up" data-aos-duration="800">

                        <?php echo $__env->make('frontend.templates.layouts.contact_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End section -->

    <div class="optech-map-page">
        <iframe
        src="<?php echo e(html_decode($contact_us->map_code)); ?>"
        allowfullscreen=""
        width="100%"
        height="650"
        class="map-radius"
        loading="lazy"
        referrerpolicy="no-referrer-when-downgrade"
      ></iframe>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/contact_us.blade.php ENDPATH**/ ?>