<?php
    $currentLang = session()->get('front_lang');
    $contactContent = getContent('contact_form_section.content', true);
?>
<h3><?php echo e(getTranslatedValue($contactContent, 'heading', $currentLang)); ?></h3>
<p><?php echo e(getTranslatedValue($contactContent, 'description', $currentLang)); ?></p>
<form action="<?php echo e(route('store-contact-message')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="col-lg-6">
            <div class="optech-main-field">
                <input
                    type="text"
                    id="name"
                    placeholder="<?php echo e(__('translate.Name')); ?>"
                    name="name"
                    value="<?php echo e(old('name')); ?>"
                />
            </div>
        </div>
        <div class="col-lg-6">
            <div class="optech-main-field">
                <input
                    type="text"
                    id="phone"
                    placeholder="<?php echo e(__('translate.Phone')); ?>"
                    name="phone"
                    value="<?php echo e(old('phone')); ?>"
                />
            </div>
        </div>
        <div class="col-lg-12">
            <div class="optech-main-field">
                <input
                    type="email"
                    id="email"
                    placeholder="<?php echo e(__('translate.Email')); ?>"
                    name="email"
                    value="<?php echo e(old('email')); ?>"
                />
            </div>
        </div>
        <div class="col-lg-12">
            <div class="optech-main-field">
                <textarea name="message" placeholder="<?php echo e(__('translate.Message')); ?>"><?php echo e(old('message') ? trim(old('message')) : ''); ?></textarea>
            </div>
        </div>

    <?php if($general_setting->recaptcha_status==1): ?>
            <div class="optech-main-field">
                <div class="g-recaptcha" data-sitekey="<?php echo e($general_setting->recaptcha_site_key); ?>"></div>
            </div>
        <?php endif; ?>
        <div class="col-lg-12">
            <button id="optech-main-form-btn" type="submit" data-text="<?php echo e(getTranslatedValue($contactContent, 'button_text', $currentLang)); ?>">
                <span class="btn-wraper"><?php echo e(getTranslatedValue($contactContent, 'button_text', $currentLang)); ?></span>
            </button>
        </div>
    </div>
</form>
<?php /**PATH /home/innoverahub/public_html/resources/views/frontend/templates/layouts/contact_form.blade.php ENDPATH**/ ?>