<?php if($products->hasPages()): ?>
    <div class="optech-navigation">
        <nav class="navigation pagination center" aria-label="Posts">
            <div class="nav-links">
                <?php if($products->onFirstPage()): ?>
                    <span class="next page-numbers disabled">
                                <i class="ri-arrow-left-s-line"></i>
                            </span>
                <?php else: ?>
                    <a class="next page-numbers" href="<?php echo e($products->previousPageUrl()); ?>">
                        <i class="ri-arrow-left-s-line"></i>
                    </a>
                <?php endif; ?>

                <?php
                    $start = max($products->currentPage() - 2, 1);
                    $end = min($start + 4, $products->lastPage());
                    $start = max(min($start, $products->lastPage() - 4), 1);
                ?>

                <?php if($start > 1): ?>
                    <a class="page-numbers" href="<?php echo e($products->url(1)); ?>">1</a>
                    <?php if($start > 2): ?>
                        <span class="page-numbers dots">...</span>
                    <?php endif; ?>
                <?php endif; ?>

                <?php for($i = $start; $i <= $end; $i++): ?>
                    <?php if($i == $products->currentPage()): ?>
                        <span aria-current="page"
                              class="page-numbers current"><?php echo e($i); ?></span>
                    <?php else: ?>
                        <a class="page-numbers" href="<?php echo e($products->url($i)); ?>"><?php echo e($i); ?></a>
                    <?php endif; ?>
                <?php endfor; ?>

                <?php if($end < $products->lastPage()): ?>
                    <?php if($end < $products->lastPage() - 1): ?>
                        <span class="page-numbers dots">...</span>
                    <?php endif; ?>
                    <a class="page-numbers"
                       href="<?php echo e($products->url($products->lastPage())); ?>"><?php echo e($products->lastPage()); ?></a>
                <?php endif; ?>

                <?php if($products->hasMorePages()): ?>
                    <a class="next page-numbers" href="<?php echo e($products->nextPageUrl()); ?>">
                        <i class="ri-arrow-right-s-line"></i>
                    </a>
                <?php else: ?>
                    <span class="next page-numbers disabled">
                                <i class="ri-arrow-right-s-line"></i>
                            </span>
                <?php endif; ?>
            </div>
        </nav>
    </div>
<?php endif; ?>
<?php /**PATH /home/innoverahub/public_html/resources/views/frontend/shop/paginate.blade.php ENDPATH**/ ?>