<?php $__env->startSection('new-layout'); ?>
    <?php
        $currentLang = session()->get('front_lang');
        $pricingContent = getContent('it_solutions_pricing_section.content', true);
                $packageInformation = $currentLang === 'en'
               ? ($pricingContent->data_values['package_information'] ?? [])
               : getTranslatedValue($pricingContent, 'package_information', $currentLang);
    ?>
    <div class="optech-breadcrumb" style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
        <div class="container">
            <h1 class="post__title"><?php echo e(__($pageTitle)); ?></h1>
            <nav class="breadcrumbs">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                    <li aria-current="page"><?php echo e(__($pageTitle)); ?></li>
                </ul>
            </nav>
        </div>
    </div>
    <!-- End breadcrumb -->
    <div class="section optech-section-padding2">
        <div class="container">
            <div class="row">
                <?php if(is_array($packageInformation)): ?>
                    <?php $__currentLoopData = $packageInformation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-md-6" data-aos="fade-up" data-aos-duration="<?php echo e(600 + ($loop->index * 200)); ?>">
                            <div class="optech-pricing-wrap <?php echo e($loop->iteration == 2 ? 'active' : ''); ?>">
                                <div class="optech-pricing-header">
                                    <h4><?php echo e($package['title'] ?? ''); ?></h4>
                                    <p><?php echo e($package['description'] ?? ''); ?></p>
                                </div>
                                <div class="optech-pricing-price">
                                    <h2><?php echo e(currency($package['price']) ?? '0'); ?><span>/<?php echo e(__('translate.month')); ?></span></h2>
                                </div>
                                <div class="optech-pricing-feature">
                                    <ul>
                                        <?php if(isset($package['features']) && is_array($package['features'])): ?>
                                            <?php $__currentLoopData = $package['features']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><i class="ri-check-line"></i><?php echo e($feature); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <a class="optech-pricing-btn" href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('translate.Select This Plan')); ?></a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-12">
                        <p class="text-center"><?php echo e(__('translate.No pricing packages available')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php echo $__env->make('frontend.templates.layouts.faq', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- End -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/frontend/pricing.blade.php ENDPATH**/ ?>