<?php
    $contactInfoContent = getContent('contact_info_section.content', true);
    $contactContent = getContent('contact_form_section.content', true);
?>
<div class="section optech-section-padding bg-light1">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 d-flex align-items-center">
                <div class="optech-default-content mr40">
                    <h2><?php echo e(getTranslatedValue($contactInfoContent, 'heading', $currentLang)); ?></h2>
                    <p><?php echo e(getTranslatedValue($contactInfoContent, 'description', $currentLang)); ?></p>
                    <div class="optech-contact-info-column">
                        <div class="optech-contact-info">
                            <i class="ri-map-pin-2-fill"></i>
                            <h5><?php echo e(__('translate.Address')); ?></h5>
                            <p><?php echo e($footer->address); ?></p>
                        </div>
                        <div class="optech-contact-info">
                            <i class="ri-mail-fill"></i>
                            <h5><?php echo e(__('translate.Contact')); ?></h5>
                            <a href="mailto:<?php echo e($footer->email); ?>"><?php echo e($footer->email); ?></a>
                            <a href="tel:<?php echo e($footer->phone); ?>"><?php echo e($footer->phone); ?></a>
                        </div>
                    </div>
                    <?php echo e(__('translate.Office Hours')); ?>: <?php echo e(getTranslatedValue($contactInfoContent, 'office_hours', $currentLang)); ?>

                </div>
            </div>
            <div class="col-lg-6" data-aos="fade-up" data-aos-duration="600">
                <div class="optech-main-form bg-white ml60">
                    <?php echo $__env->make('frontend.templates.layouts.contact_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/innoverahub/public_html/resources/views/frontend/templates/layouts/contact_section.blade.php ENDPATH**/ ?>