<?php use Modules\Blog\App\Models\Blog; ?>


<?php $__env->startSection('title'); ?>
    <title><?php echo e($blog->seo_title); ?></title>
    <meta name="title" content="<?php echo e($blog->seo_title); ?>">
    <meta name="description" content="<?php echo e($blog->seo_description); ?>">

    <?php
        $tags = '';
        if($blog->tags){
            foreach (json_decode($blog->tags) as $key => $blog_tag) {
                $tags .= $blog_tag->value.', ';
            }
        }
    ?>

    <meta name="keyword" content="<?php echo e($tags); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Main Start -->
<div class="optech-breadcrumb" style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
    <div class="container">
        <h1 class="post__title"><?php echo e($blog->translate?->title); ?></h1>
        <nav class="breadcrumbs">
            <ul>
                <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                <li><a href="<?php echo e(route('blogs')); ?>"><?php echo e(__('translate.Blog')); ?></a></li>
                <li aria-current="page"><?php echo e($blog->translate?->title); ?></li>
            </ul>
        </nav>
    </div>
</div>
<!-- End breadcrumb -->

<div class="section optech-section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="optech-blog-thumb single-blog" data-aos="fade-up" data-aos-duration="800">
                    <img src="<?php echo e(asset($blog->image)); ?>" alt="Blog Image">
                </div>
                <div class="optech-single-post-content-wrap">
                    <div class="optech-single-post-meta">
                        <ul>
                            <li><a href=""><i class="ri-calendar-fill"></i><?php echo e(__($blog->created_at->format('d M Y'))); ?></a></li>
                            <li><a href=""><i class="ri-bookmark-fill"></i><?php echo e($blog->category->translate?->name); ?></a></li>
                            <li><a href=""><i class="ri-chat-2-fill"></i> <?php echo e($blog->total_comment); ?> <?php echo e(__('translate.Comments')); ?></a></li>
                        </ul>
                    </div>
                    <div class="entry-content">
                        <p>
                            <?php echo clean($blog->translate?->description); ?>

                        </p>

                        <div class="optech-single-post-tag-wrap">
                            <div class="optech-blog-tags">
                                <ul>
                                    <?php if($blog->tags): ?>
                                        <?php $__currentLoopData = json_decode($blog->tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog_tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a href="javascript:;"><?php echo e($blog_tag->value); ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>

                        <div class="optech-post-navigation">
                            <?php if($previous): ?>
                                <a href="<?php echo e(route('blog', $previous->slug)); ?>" class="nav-previous">
                                    <i class="ri-arrow-left-line"></i> <?php echo e(__('translate.Previous Post')); ?>

                                </a>
                            <?php else: ?>
                                <span class="nav-previous disabled">
                                    <i class="ri-arrow-left-line"></i>
                                    <?php echo e(__('translate.No Previous Post')); ?>

                                </span>
                            <?php endif; ?>
                            <?php if($next): ?>
                                <a href="<?php echo e(route('blog', $next->slug)); ?>" class="nav-next">
                                    <?php echo e(__('translate.Next Post')); ?> <i class="ri-arrow-right-line"></i>
                                </a>
                                <?php else: ?>
                                 <span class="nav-next disabled">
                                    <?php echo e(__('translate.No Next Post')); ?>

                                    <i class="ri-arrow-right-line"></i>
                                </span>
                            <?php endif; ?>
                        </div>

                        <div class="optech-post-comment">
                            <h3><?php echo e(__('translate.Comments:')); ?></h3>
                            <ul>
                                <?php $__currentLoopData = $blog_comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog_comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="optech-post-comment-wrap">
                                        <div class="optech-post-comment-thumb">
                                            <img src="<?php echo e(asset($general_setting->default_avatar)); ?>" alt="">
                                        </div>
                                        <div class="optech-post-comment-data">
                                            <p>
                                                <?php echo e(html_decode($blog_comment->comment)); ?>

                                            </p>
                                            <strong><?php echo e(html_decode($blog_comment->name)); ?></strong> <span><?php echo e($blog_comment->created_at->format('d M Y')); ?></span>

                                        </div>
                                    </div>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="optech-comment-box">
                            <h3><?php echo e(__('translate.Leave a comments:')); ?></h3>
                            <form action="<?php echo e(route('store-blog-comment', $blog->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="optech-comment-box-form">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="optech-comment-form">
                                                <input
                                                    type="text"
                                                    id="name"
                                                    name="name"
                                                    value="<?php echo e(old('name')); ?>"
                                                    placeholder="Name"
                                                >
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="optech-comment-form">
                                                <input
                                                    type="email"
                                                    id="email"
                                                    name="email"
                                                    value="<?php echo e(old('email')); ?>"
                                                    placeholder="Email"
                                                >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="optech-comment-form">
                                       <textarea
                                           id="desc"
                                           name="comment"
                                           placeholder="Comment"
                                       ><?php echo e(old('comment')); ?>

                                       </textarea>
                                    </div>
                                    <div class="optech-check">
                                        <input type="checkbox" id="css">
                                        <label for="css">
                                            <?php echo e(__('translate.Save my name, email, and website in this browser for the next time I comment')); ?>.
                                        </label>
                                    </div>

                                    <?php if($general_setting->recaptcha_status == 1): ?>
                                        <div class="contact-form-input col-lg-12 mt-4">
                                            <div class="g-recaptcha" data-sitekey="<?php echo e($general_setting->recaptcha_site_key); ?>"></div>
                                        </div>
                                    <?php endif; ?>

                                    <button id="optech-default-btn" type="submit" data-text="Send Message">
                                        <span class="btn-wraper">
                                            <?php echo e(__('translate.Send Message')); ?>

                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <?php echo $__env->make('blog_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
    <!-- End Main Blog Details -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.templates.main_demo_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/blog_detail.blade.php ENDPATH**/ ?>