<?php
    $currentLang = session()->get('front_lang');
    $faqSection = getContent('digital_agency_faqs.content', true);
?>
<div class="section bg-light1 optech-section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="optech-default-content">
                    <h2><?php echo e(getTranslatedValue($faqSection, 'heading', $currentLang)); ?></h2>
                    <p><?php echo e(getTranslatedValue($faqSection, 'description', $currentLang)); ?></p>
                    <div class="optech-extra-mt" data-aos="fade-up" data-aos-duration="800">
                        <a class="optech-default-btn" href="<?php echo e(route('faq')); ?>" data-text="<?php echo e(getTranslatedValue($faqSection, 'button_text', $currentLang)); ?>"><span
                                class="btn-wraper"><?php echo e(getTranslatedValue($faqSection, 'button_text', $currentLang)); ?></span></a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 offset-lg-1">
                <div class="optech-accordion-wrap init-wrap">
                    <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="optech-accordion-item <?php echo e($loop->first ? 'open' : ''); ?>">
                            <div class="optech-accordion-header init-header">
                                <h5> <?php echo e(__('translate.Q')); ?><?php echo e($loop->iteration); ?>. <?php echo e($faq->translate?->question); ?></h5>
                            </div>
                            <div class="optech-accordion-body init-body">
                                <p><?php echo clean($faq->translate?->answer); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/innoverahub/public_html/resources/views/frontend/templates/layouts/faq.blade.php ENDPATH**/ ?>