<?php $__env->startSection('title'); ?>
<title><?php echo e($seo_setting->seo_title); ?></title>
<meta name="title" content="<?php echo e($seo_setting->seo_title); ?>"/>
<meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('new-layout'); ?>
<!-- Main Start -->
<div class="optech-breadcrumb" style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
    <div class="container">
        <h1 class="post__title"><?php echo e(__('translate.Blogs')); ?></h1>
        <nav class="breadcrumbs">
            <ul>
                <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                <li aria-current="page"> <?php echo e(__('translate.Blogs')); ?></li>
            </ul>
        </nav>

    </div>
</div>

<?php
    $isGrid = request()->query('type') === 'grid';
?>
<!-- End breadcrumb -->
<?php if(!$isGrid): ?>
<!-- Non Grid Blogs Start -->
<div class="section optech-section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div data-aos="fade-up" data-aos-duration="600">
                    <div class="optech-blog-wrap">
                        <a href="<?php echo e(route('blog', $blog->slug)); ?>">
                            <div class="optech-blog-thumb optech-blog-thumb-big">
                                <img src="<?php echo e(asset($blog->image)); ?>" alt="Blog Image">
                            </div>
                        </a>
                        <div class="optech-blog-content">
                            <div class="optech-blog-meta">
                                <ul>
                                    <li><a href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e($blog->category->translate?->name); ?></a></li>
                                    <li><a href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e($blog->created_at->format('d F Y')); ?></a></li>
                                </ul>
                            </div>
                            <a href="<?php echo e(route('blog', $blog->slug)); ?>">
                                <h2><?php echo e($blog->translate->title); ?></h2>
                            </a>
                            <p>
                                <?php echo Str::limit(clean($blog->translate->description), 180, '...'); ?>

                            </p>
                            <a class="optech-icon-btn" href="<?php echo e(route('blog', $blog->slug)); ?>"><i class="icon-show ri-arrow-right-line"></i>
                                <span><?php echo e(__('translate.Learn More')); ?></span> <i class="icon-hide ri-arrow-right-line"></i></a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php echo $__env->make('blog_not_found', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>


                <?php if($blogs->hasPages()): ?>
                        <div class="optech-navigation">
                            <nav class="navigation pagination" aria-label="Posts">
                                <div class="nav-links">
                                    <?php if($blogs->onFirstPage()): ?>
                                        <span class="next page-numbers disabled">
                                            <i class="ri-arrow-left-s-line"></i>
                                        </span>
                                    <?php else: ?>
                                        <a class="next page-numbers" href="<?php echo e($blogs->previousPageUrl()); ?>">
                                            <i class="ri-arrow-left-s-line"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php
                                        $start = max($blogs->currentPage() - 2, 1);
                                        $end = min($start + 4, $blogs->lastPage());
                                        $start = max(min($start, $blogs->lastPage() - 4), 1);
                                    ?>

                                    <?php if($start > 1): ?>
                                        <a class="page-numbers" href="<?php echo e($blogs->url(1)); ?>">1</a>
                                        <?php if($start > 2): ?>
                                            <span class="page-numbers dots">...</span>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php for($i = $start; $i <= $end; $i++): ?>
                                        <?php if($i == $blogs->currentPage()): ?>
                                            <span aria-current="page" class="page-numbers current"><?php echo e($i); ?></span>
                                        <?php else: ?>
                                            <a class="page-numbers" href="<?php echo e($blogs->url($i)); ?>"><?php echo e($i); ?></a>
                                        <?php endif; ?>
                                    <?php endfor; ?>

                                    <?php if($end < $blogs->lastPage()): ?>
                                        <?php if($end < $blogs->lastPage() - 1): ?>
                                            <span class="page-numbers dots">...</span>
                                        <?php endif; ?>
                                        <a class="page-numbers" href="<?php echo e($blogs->url($blogs->lastPage())); ?>"><?php echo e($blogs->lastPage()); ?></a>
                                    <?php endif; ?>

                                    <?php if($blogs->hasMorePages()): ?>
                                        <a class="next page-numbers" href="<?php echo e($blogs->nextPageUrl()); ?>">
                                            <i class="ri-arrow-right-s-line"></i>
                                        </a>
                                    <?php else: ?>
                                        <span class="next page-numbers disabled">
                                            <i class="ri-arrow-right-s-line"></i>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            <?php echo $__env->make('blog_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php else: ?>
<!-- Non Grid Blogs End -->

<!-- Grid Blogs Start -->
<div class="section optech-section-padding optech-blog-grid">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xl-4 col-md-6" data-aos="fade-up" data-aos-duration="600">
                <div class="optech-blog-wrap">
                    <a href="<?php echo e(route('blog', $blog->slug)); ?>">
                        <div class="optech-blog-thumb ">
                            <img src="<?php echo e(asset($blog->image)); ?>" alt="Image Blog">
                        </div>
                    </a>
                    <div class="optech-blog-content">
                        <div class="optech-blog-meta">
                            <ul>
                                <li><a href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e($blog->category->translate?->name); ?></a></li>
                                <li><a href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e($blog->created_at->format('d F Y')); ?></a></li>
                            </ul>
                        </div>
                        <a href="<?php echo e(route('blog', $blog->slug)); ?>">
                            <h4><?php echo e($blog->translate->title); ?></h4>
                        </a>
                        <a class="optech-icon-btn" href="<?php echo e(route('blog', $blog->slug)); ?>"><i class="icon-show ri-arrow-right-line"></i>
                            <span>
                                <?php echo e(__('translate.Learn More')); ?>

                            </span> <i class="icon-hide ri-arrow-right-line"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php if($blogs->hasPages()): ?>
            <div class="optech-navigation">
                <nav class="navigation pagination center" aria-label="Posts">
                    <div class="nav-links">
                        <?php if($blogs->onFirstPage()): ?>
                            <span class="next page-numbers disabled">
                        <i class="ri-arrow-left-s-line"></i>
                    </span>
                        <?php else: ?>
                            <a class="next page-numbers" href="<?php echo e($blogs->previousPageUrl()); ?>">
                                <i class="ri-arrow-left-s-line"></i>
                            </a>
                        <?php endif; ?>

                        <?php
                            $start = max($blogs->currentPage() - 2, 1);
                            $end = min($start + 4, $blogs->lastPage());
                            $start = max(min($start, $blogs->lastPage() - 4), 1);
                        ?>

                        <?php if($start > 1): ?>
                            <a class="page-numbers" href="<?php echo e($blogs->url(1)); ?>">1</a>
                            <?php if($start > 2): ?>
                                <span class="page-numbers dots">...</span>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php for($i = $start; $i <= $end; $i++): ?>
                            <?php if($i == $blogs->currentPage()): ?>
                                <span aria-current="page" class="page-numbers current"><?php echo e($i); ?></span>
                            <?php else: ?>
                                <a class="page-numbers" href="<?php echo e($blogs->url($i)); ?>"><?php echo e($i); ?></a>
                            <?php endif; ?>
                        <?php endfor; ?>

                        <?php if($end < $blogs->lastPage()): ?>
                            <?php if($end < $blogs->lastPage() - 1): ?>
                                <span class="page-numbers dots">...</span>
                            <?php endif; ?>
                            <a class="page-numbers" href="<?php echo e($blogs->url($blogs->lastPage())); ?>"><?php echo e($blogs->lastPage()); ?></a>
                        <?php endif; ?>

                        <?php if($blogs->hasMorePages()): ?>
                            <a class="next page-numbers" href="<?php echo e($blogs->nextPageUrl()); ?>">
                                <i class="ri-arrow-right-s-line"></i>
                            </a>
                        <?php else: ?>
                            <span class="next page-numbers disabled">
                        <i class="ri-arrow-right-s-line"></i>
                    </span>
                        <?php endif; ?>
                    </div>
                </nav>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>
<!-- Grid Blogs Start End  -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/blogs.blade.php ENDPATH**/ ?>