<div class="col-lg-4">
    <div class="optech-blog-sidebar">
        <div class="optech-blog-widgets">
            <h5><?php echo e(__('translate.Search')); ?></h5>
            <form action="<?php echo e(route('blogs')); ?>">
                <div class="optech-search-box">
                    <input type="search" placeholder="Type to search..." name="search" value="<?php echo e(request('search')); ?>">
                    <button id="optech-search-btn" type="button"><i class="ri-search-line"></i></button>
                </div>
            </form>
        </div>
        <div class="optech-blog-widgets">
            <h5><?php echo e(__('translate.Categories')); ?></h5>
            <div class="optech-blog-categorie">
                <ul>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('blogs', ['category' => $category->slug])); ?>"><?php echo e($category->translate->name); ?><span>(<?php echo e($category->blogs_count); ?>)</span></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>

        <div class="optech-blog-widgets">
            <h5><?php echo e(__('translate.Recent Posts')); ?></h5>
            <?php $__empty_1 = true; $__currentLoopData = $recent_blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent_blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <a class="optech-recent-post-item" href="<?php echo e(route('blog', $recent_blog->slug)); ?>">
                    <div class="optech-recent-post-thumb">
                        <?php if($recent_blog->image): ?>
                            <img src="<?php echo e(asset($recent_blog->image)); ?>" alt="<?php echo e($recent_blog->title); ?>">
                        <?php endif; ?>
                    </div>
                    <div class="optech-recent-post-data">
                        <p><?php echo e(Str::limit($recent_blog->title, 60)); ?></p>
                        <span><?php echo e($recent_blog->created_at->format('d F Y')); ?></span>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="no-posts">
                    <p><?php echo e(__('translate.No recent posts available')); ?></p>
                </div>
            <?php endif; ?>
        </div>

        <div class="optech-blog-widgets">
            <h5><?php echo e(__('translate.Tags')); ?></h5>
            <div class="optech-blog-tags">
                <ul>
                    <?php $__currentLoopData = $allTags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a href="<?php echo e(route('blogs', ['tag' => $tag])); ?>"
                           class="<?php echo e(request('tag') === $tag ? 'active' : ''); ?>">
                            <?php echo e($tag); ?>

                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/innoverahub/public_html/resources/views/blog_sidebar.blade.php ENDPATH**/ ?>