<?php $__env->startSection('new-layout'); ?>
    <div class="optech-breadcrumb" style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
        <div class="container">
            <h1 class="post__title"><?php echo e(__($pageTitle)); ?></h1>
            <nav class="breadcrumbs">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                    <li><a href="<?php echo e(route('teams')); ?>"><?php echo e(__('translate.Our Teams')); ?></a></li>
                    <li aria-current="page"><?php echo e(__($pageTitle)); ?></li>
                </ul>
            </nav>
        </div>
    </div>

    <!-- End breadcrumb -->


    <div class="section optech-section-padding">
        <div class="container">
            <div class="optech-team-single-wrap">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="optech-team-single-thumb" data-aos="fade-up" data-aos-duration="800">
                            <img src="<?php echo e(asset($team->image)); ?>" alt="">
                        </div>
                    </div>
                    <div class="col-lg-6 offset-lg-1">
                        <div class="optech-team-single-content">
                            <h2><?php echo e($team->translate->name); ?></h2>
                            <span><?php echo e($team->translate->designation); ?></span>
                            <p><?php echo clean($team->translate->description); ?></p>
                            <div class="optech-footer-info dark-color">
                                <ul>
                                    <li><a href="tel:<?php echo e($team->phone_number); ?>"><i class="ri-phone-fill"></i><?php echo e($team->phone_number); ?></a></li>
                                    <li><a href="mailto:<?php echo e($team->mail); ?>"><i class="ri-mail-fill"></i><?php echo e($team->mail); ?></a></li>
                                </ul>
                            </div>
                            <div class="optech-extra-mt">
                                <div class="optech-social-icon-box style-two">
                                    <ul>
                                        <li>
                                            <a href="<?php echo e($team->facebook); ?>">
                                                <i class="ri-facebook-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e($team->linkedin); ?>">
                                                <i class="ri-linkedin-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e($team->twitter); ?>">
                                                <i class="ri-twitter-fill"></i>
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e($team->instagram); ?>">
                                                <i class="ri-instagram-fill"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="optech-main-form p-0">
                            <?php echo $__env->make('frontend.templates.layouts.contact_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End section -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/frontend/team_single.blade.php ENDPATH**/ ?>