<?php
    $currentLang = session()->get('front_lang');
    $ctaContent = getContent('main_demo_cta_section.content', true);
?>

<div class="section bg-cover optech-section-padding cta-bg3  <?php echo e(Route::is('home') ? 'custom-image-two-home' : 'custom-image-two'); ?>">
    <div class="container">
        <div class="optech-cta-wrap">
            <div class="optech-cta-content center">
                <h2><?php echo e(getTranslatedValue($ctaContent, 'heading', $currentLang)); ?></h2>
                <p><?php echo e(getTranslatedValue($ctaContent, 'description', $currentLang)); ?></p>
                <div class="optech-extra-mt" data-aos="fade-up" data-aos-duration="600">
                    <a class="optech-default-btn optech-white-btn" href="<?php echo e(route($ctaContent->data_values['button_link'])); ?>" data-text="<?php echo e(getTranslatedValue($ctaContent, 'button_text', $currentLang)); ?>">
                        <span class="btn-wraper"><?php echo e(getTranslatedValue($ctaContent, 'button_text', $currentLang)); ?></span> </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/innoverahub/public_html/resources/views/frontend/templates/layouts/main_demo_cta.blade.php ENDPATH**/ ?>