<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('new-layout'); ?>

    <?php
        $currentLang = session()->get('front_lang');
        $faqContent = getContent('faq_section.content', true);
    ?>

    <div class="optech-breadcrumb" style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
        <div class="container">
            <h1 class="post__title"><?php echo e(__($pageTitle)); ?></h1>
            <nav class="breadcrumbs">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>

                    <li aria-current="page"><?php echo e(__($pageTitle)); ?></li>
                </ul>
            </nav>
        </div>
    </div>

    <div class="section accordion-page">
        <div class="container">
            <div class="optech-accordion-column">
                <div class="optech-accordion-wrap mt-0 init-wrap">
                    <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="optech-accordion-item <?php echo e($loop->first ? 'open' : ''); ?>">
                        <div class="optech-accordion-header init-header">
                            <h5> <span> <?php echo e(__('translate.Q')); ?> </span><?php echo e($loop->iteration); ?>. <?php echo e($faq->translate?->question); ?></h5>
                        </div>
                        <div class="optech-accordion-body init-body">
                            <p><?php echo clean($faq->translate?->answer); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <!-- End section -->

    <div class="section optech-section-padding-bottom">
        <div class="container">
            <div class="optech-default-content sm-mw">
                <h2><?php echo e(getTranslatedValue($faqContent, 'heading', $currentLang)); ?></h2>
                <p><?php echo e(getTranslatedValue($faqContent, 'description', $currentLang)); ?></p>
                <div class="optech-extra-mt" data-aos="fade-up" data-aos-duration="800">
                    <a class="optech-default-btn optech-light-btn" href="<?php echo e(route('contact-us')); ?>" data-text="<?php echo e(getTranslatedValue($faqContent, 'button_text', $currentLang)); ?>"> <span
                            class="btn-wraper"><?php echo e(getTranslatedValue($faqContent, 'button_text', $currentLang)); ?></span> </a>
                </div>
            </div>
        </div>
    </div>
    <!-- End section -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/faq.blade.php ENDPATH**/ ?>