<?php $__env->startSection('new-layout'); ?>

    <!-- START GRID SECTION -->
    <!-- Main Start -->
    <div class="optech-breadcrumb"
         style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>)">
        <div class="container">
            <h1 class="post__title"><?php echo e(__('translate.Portfolio')); ?></h1>
            <nav class="breadcrumbs">
                <ul>
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                    <li aria-current="page"> <?php echo e(__('translate.Portfolio')); ?></li>
                </ul>
            </nav>

        </div>
    </div>
    <?php
        $isGrid = request()->query('type') === 'grid';
    ?>

    <?php if(!$isGrid): ?>
        <div class="section optech-section-padding">
            <div class="container">
                <div class="optech-section-title center">
                    <h2><?php echo e(__('translate.Explore our recent projects')); ?></h2>
                </div>
                <div class="row">
                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($loop->iteration == 5 || $loop->iteration == 6): ?>
                            <div class="col-xl-8" data-aos="fade-up" data-aos-duration="<?php echo e($loop->iteration * 200); ?>">
                                <?php else: ?>
                                    <div class="col-xl-4 col-md-6" data-aos="fade-up"
                                         data-aos-duration="<?php echo e($loop->iteration * 200); ?>">
                                        <?php endif; ?>
                                        <div class="optech-portfolio-wrap">
                                            <div class="optech-portfolio-thumb optech-portfolio-thumb-2 optech-portfolio-thumb-main   ">
                                                <img src="<?php echo e(asset($project->thumb_image)); ?>" alt="Image" class="full-img">
                                                <a class="optech-portfolio-btn"
                                                   href="<?php echo e(route('portfolio.show', $project->slug)); ?>">
                                                    <span class="p-btn-wraper"><i
                                                            class="ri-arrow-right-up-line"></i></span>
                                                </a>
                                                <div class="optech-portfolio-data">
                                                    <a href="<?php echo e(route('portfolio.show', $project->slug)); ?>">
                                                        <h4><?php echo e(__($project->translate->title)); ?></h4>
                                                    </a>
                                                    <p><?php if($project->category && $project->category->translate): ?>
                                                            <?php echo e($project->category->translate->name); ?>

                                                        <?php elseif($project->category): ?>
                                                            <?php echo e($project->category->name); ?>

                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                                        <?php if($projects->hasPages()): ?>
                                            <div class="optech-navigation">
                                                <nav class="navigation pagination center" aria-label="Posts">
                                                    <div class="nav-links">
                                                        <?php if($projects->onFirstPage()): ?>
                                                            <span class="next page-numbers disabled">
                                            <i class="ri-arrow-left-s-line"></i>
                                        </span>
                                            <?php else: ?>
                                                <a class="next page-numbers" href="<?php echo e($projects->previousPageUrl()); ?>">
                                                    <i class="ri-arrow-left-s-line"></i>
                                                </a>
                                            <?php endif; ?>

                                            <?php
                                                $start = max($projects->currentPage() - 2, 1);
                                                $end = min($start + 4, $projects->lastPage());
                                                $start = max(min($start, $projects->lastPage() - 4), 1);
                                            ?>

                                            <?php if($start > 1): ?>
                                                <a class="page-numbers" href="<?php echo e($projects->url(1)); ?>">1</a>
                                                <?php if($start > 2): ?>
                                                    <span class="page-numbers dots">...</span>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <?php for($i = $start; $i <= $end; $i++): ?>
                                                <?php if($i == $projects->currentPage()): ?>
                                                    <span aria-current="page"
                                                          class="page-numbers current"><?php echo e($i); ?></span>
                                                <?php else: ?>
                                                    <a class="page-numbers" href="<?php echo e($projects->url($i)); ?>"><?php echo e($i); ?></a>
                                                <?php endif; ?>
                                            <?php endfor; ?>

                                            <?php if($end < $projects->lastPage()): ?>
                                                <?php if($end < $projects->lastPage() - 1): ?>
                                                    <span class="page-numbers dots">...</span>
                                                <?php endif; ?>
                                                <a class="page-numbers"
                                                   href="<?php echo e($projects->url($projects->lastPage())); ?>"><?php echo e($projects->lastPage()); ?></a>
                                            <?php endif; ?>

                                            <?php if($projects->hasMorePages()): ?>
                                                <a class="next page-numbers" href="<?php echo e($projects->nextPageUrl()); ?>">
                                                    <i class="ri-arrow-right-s-line"></i>
                                                </a>
                                            <?php else: ?>
                                                <span class="next page-numbers disabled">
                                                    <i class="ri-arrow-right-s-line"></i>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </nav>
                                </div>
                            <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- Masonry  End section -->
    <?php else: ?>
        <!-- Grid End section -->
        <div class="section optech-section-padding">
            <div class="container">
                <div class="row">
                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-md-6" data-aos="fade-up" data-aos-duration="500">
                            <div class="optech-portfolio-wrap">
                                <div class="optech-portfolio-thumb optech-portfolio-thumb-digital">
                                    <img src="<?php echo e(asset($project->thumb_image)); ?>" alt="Image" class="full-img">
                                    <a class="optech-portfolio-btn"
                                       href="<?php echo e(route('portfolio.show', $project->slug)); ?>">
                                        <span class="p-btn-wraper"><i class="ri-arrow-right-up-line"></i></span>
                                    </a>
                                    <div class="optech-portfolio-data">
                                        <a href="<?php echo e(route('portfolio.show', $project->slug)); ?>">
                                            <h4><?php echo e(__($project->translate->title)); ?></h4>
                                        </a>
                                        <p><?php if($project->category && $project->category->translate): ?>
                                                <?php echo e($project->category->translate->name); ?>

                                            <?php elseif($project->category): ?>
                                                <?php echo e($project->category->name); ?>

                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>


            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/innoverahub/public_html/resources/views/frontend/templates/portfolio.blade.php ENDPATH**/ ?>