<div class="menu-block-wrapper">
    <div class="menu-overlay"></div>
    <nav class="menu-block" id="append-menu-header">
        <div class="mobile-menu-head">
            <div class="go-back">
                <i class="fa fa-angle-left"></i>
            </div>
            <div class="current-menu-title"></div>
            <div class="mobile-menu-close">&times;</div>
        </div>

        <ul class="site-menu-main <?php echo e($menuTheme ?? ''); ?>">

            <?php
                $currentTheme = Modules\GlobalSetting\App\Models\GlobalSetting::where('key', 'selected_theme')->first()?->value ?? 'all_theme';
            ?>

            <?php if(config('app.env') === 'DEMO' || $currentTheme === 'all_theme'): ?>
                <li class="nav-item nav-item-has-children">
                    <a href="#" class="nav-link-item drop-trigger"><?php echo e(__('translate.Home')); ?> <i
                            class="ri-arrow-down-s-fill"></i></a>
                    <ul class="sub-menu" id="submenu-1">
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'main_demo'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'main_demo' ? 'active' : ''); ?>"><?php echo e(__('translate.Main Demo')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'it_solutions'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'it_solutions' ? 'active' : ''); ?>"><?php echo e(__('translate.IT Solutions')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'tech_agency'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'tech_agency' ? 'active' : ''); ?>"><?php echo e(__('translate.Tech Agency')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'startup_home'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'startup_home' ? 'active' : ''); ?>"><?php echo e(__('translate.Startup Home')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'it_consulting'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'it_consulting' ? 'active' : ''); ?>"><?php echo e(__('translate.IT Consulting')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'soft_company'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'soft_company' ? 'active' : ''); ?>"><?php echo e(__('translate.Software Company')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'digital_agency'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'digital_agency' ? 'active' : ''); ?>"><?php echo e(__('translate.Digital Agency')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('home', ['theme' => 'tech_company'])); ?>">
                                <span class="menu-item-text <?php echo e($currentTheme === 'tech_company' ? 'active' : ''); ?>"><?php echo e(__('translate.Tech Company')); ?></span>
                            </a>
                        </li>
                    </ul>
                </li>
            <?php else: ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('home')); ?>" class="nav-link-item">
                        <span class="menu-item-text active"><?php echo e(__('translate.Home')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <li class="nav-item">
                <a href="<?php echo e(route('product.shop')); ?>" class="nav-link-item">
                    <span class="menu-item-text"><?php echo e(__('translate.Shop')); ?></span>
                </a>
            </li>

            <li class="nav-item">
                <a href="<?php echo e(route('services')); ?>" class="nav-link-item">
                    <span class="menu-item-text"><?php echo e(__('translate.Service')); ?></span>
                </a>
            </li>


            <?php
                $portfolioType = Modules\GlobalSetting\App\Models\GlobalSetting::where('key', 'portfolio_type')->first()?->value ?? 'default';
                $isGrid = $portfolioType === 'grid';
            ?>

            <?php if(config('app.env') === 'DEMO' || $portfolioType == 'all'): ?>
                <li class="nav-item nav-item-has-children">
                <a href="#" class="nav-link-item drop-trigger"><?php echo e(__('translate.Portfolio')); ?> <i
                        class="ri-arrow-down-s-fill"></i></a>
                <ul class="sub-menu shape-none" id="submenu-6">
                    <li class="sub-menu--item">
                        <a href="<?php echo e(route('portfolio', ['type' => 'grid'])); ?>">
                            <span class="menu-item-text <?php echo e($isGrid ? 'active' : ''); ?>"><?php echo e(__('translate.Portfolio Grid')); ?></span>
                        </a>
                    </li>
                    <li class="sub-menu--item">
                        <a href="<?php echo e(route('portfolio')); ?>">
                            <span class="menu-item-text <?php echo e(!$isGrid ? 'active' : ''); ?>"><?php echo e(__('translate.Portfolio Masonry')); ?></span>
                        </a>
                    </li>

                </ul>
            </li>
            <?php else: ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('portfolio', $isGrid ? ['type' => 'grid'] : [])); ?>" class="nav-link-item">
                        <span class="menu-item-text active"><?php echo e(__('translate.Portfolio')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <?php
                $blogType = Modules\GlobalSetting\App\Models\GlobalSetting::where('key', 'blog_type')->first()?->value ?? 'default';
                $isGrid = $blogType === 'grid';
            ?>

            <?php if(config('app.env') === 'DEMO' || $blogType == 'all'): ?>
                <li class="nav-item nav-item-has-children">
                    <a href="#" class="nav-link-item drop-trigger"><?php echo e(__('translate.Blog')); ?> <i
                            class="ri-arrow-down-s-fill"></i></a>
                    <ul class="sub-menu" id="submenu-9">
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('blogs')); ?>">
                                <span class="menu-item-text <?php echo e(!$isGrid ? 'active' : ''); ?>"><?php echo e(__('translate.Blog')); ?></span>
                            </a>
                        </li>
                        <li class="sub-menu--item">
                            <a href="<?php echo e(route('blogs', ['type' => 'grid'])); ?>">
                                <span class="menu-item-text <?php echo e($isGrid ? 'active' : ''); ?>"><?php echo e(__('translate.Blog Grid')); ?></span>
                            </a>
                        </li>
                    </ul>
                </li>
            <?php else: ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('blogs', $isGrid ? ['type' => 'grid'] : [])); ?>" class="nav-link-item">
                        <span class="menu-item-text active"><?php echo e(__('translate.Blog')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <li class="nav-item nav-item-has-children">
                <a href="#" class="nav-link-item drop-trigger"><?php echo e(__('translate.Pages')); ?> <i
                        class="ri-arrow-down-s-fill"></i></a>
                <ul class="sub-menu" id="submenu-2">
                    <li class="sub-menu--item">
                        <a href="<?php echo e(route('about-us')); ?>">
                            <span class="menu-item-text"><?php echo e(__('translate.About Us')); ?></span>
                        </a>
                    </li>
                    <li class="sub-menu--item">
                        <a href="<?php echo e(route('pricing')); ?>">
                            <span class="menu-item-text"><?php echo e(__('translate.Pricing Plan')); ?></span>
                        </a>
                    </li>



                    <li class="sub-menu--item ">
                        <a href="<?php echo e(route('teams')); ?>" class="drop-trigger"><?php echo e(__('translate.Our Teams')); ?>

                        </a>
                    </li>
                    <li class="sub-menu--item nav-item-has-children">
                        <a href="#" data-menu-get="h3" class="drop-trigger"><?php echo e(__('translate.Utility')); ?><i
                                class="ri-arrow-down-s-fill"></i>
                        </a>
                        <ul class="sub-menu shape-none" id="submenu-7">
                            <li class="sub-menu--item">
                                <a href="<?php echo e(route('faq')); ?>">
                                    <span
                                        class="menu-item-text"><?php echo e(__('translate.FAQ')); ?></span>
                                </a>
                            </li>

                            <li class="sub-menu--item">
                                <a href="<?php echo e(route('testimonials')); ?>">
                                    <span class="menu-item-text"><?php echo e(__('translate.Testimonials')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <?php $__currentLoopData = $custom_pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $custom_page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <li class="sub-menu--item ">
                        <a href="<?php echo e(route('custom-page', $custom_page->slug)); ?>" class="drop-trigger"><?php echo e($custom_page->page_name); ?>

                        </a>
                    </li>


                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>
            </li>




            <li class="nav-item">
                <a class="nav-link-item"
                   href="<?php echo e(route('contact-us')); ?>"><?php echo e(__('translate.Contact')); ?></a>
            </li>
        </ul>
    </nav>
</div>
<?php /**PATH /home/innoverahub/public_html/resources/views/frontend/templates/layouts/_menu_nav.blade.php ENDPATH**/ ?>