<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EmployeeDashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'role:employee']);
    }

    public function index()
    {
        $user = Auth::user();
        
        // Get employee statistics
        $activeVisits = $user->visits()->where('status', 'in_progress')->count();
        $completedVisits = $user->visits()->where('status', 'completed')->count();
        $pendingLeaves = $user->leaveRequests()->where('status', 'pending')->count();
        $approvedLeaves = $user->leaveRequests()->where('status', 'approved')->count();
        
        // Get upcoming visits
        $upcomingVisits = $user->visits()
            ->where('status', 'pending')
            ->whereDate('scheduled_date', '>=', now())
            ->with('client')
            ->orderBy('scheduled_date')
            ->limit(5)
            ->get();
        
        // Get recent completed visits
        $recentVisits = $user->visits()
            ->where('status', 'completed')
            ->with('client')
            ->latest()
            ->limit(5)
            ->get();
        
        // Get active visits for tracking
        $currentVisits = $user->visits()
            ->where('status', 'in_progress')
            ->with('client')
            ->get();
        
        return view('employee.dashboard', compact(
            'user',
            'activeVisits',
            'completedVisits',
            'pendingLeaves',
            'approvedLeaves',
            'upcomingVisits',
            'recentVisits',
            'currentVisits'
        ));
    }
}