<?php

namespace App\Policies;

use App\Models\User;
use App\Models\LeaveRequest;
use Illuminate\Auth\Access\Response;

class LeaveRequestPolicy
{
    public function view(User $user, LeaveRequest $leave): bool
    {
        return $user->hasRole('admin') || 
               $user->hasRole('supervisor') || 
               $user->id === $leave->employee_id;
    }

    public function create(User $user): bool
    {
        return $user->hasRole('employee');
    }

    public function update(User $user, LeaveRequest $leave): bool
    {
        return $user->id === $leave->employee_id && $leave->status === 'pending';
    }

    public function delete(User $user, LeaveRequest $leave): bool
    {
        return ($user->id === $leave->employee_id && $leave->status === 'pending') ||
               $user->hasRole('admin');
    }

    public function approve(User $user, LeaveRequest $leave): bool
    {
        // Supervisor can approve their subordinates' leaves
        if ($user->hasRole('supervisor')) {
            return $leave->employee->supervisor_id === $user->id;
        }
        
        // Admin can approve any leaves
        return $user->hasRole('admin');
    }
}