<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Visit;
use Illuminate\Auth\Access\Response;

class VisitPolicy
{
    public function view(User $user, Visit $visit): bool
    {
        return $user->hasRole('admin') || 
               $user->hasRole('supervisor') || 
               $user->id === $visit->employee_id;
    }

    public function update(User $user, Visit $visit): bool
    {
        return $user->hasRole('admin') || 
               ($user->hasRole('supervisor') && $visit->employee->supervisor_id === $user->id) ||
               $user->id === $visit->employee_id;
    }

    public function delete(User $user, Visit $visit): bool
    {
        return $user->hasRole('admin') || 
               ($user->hasRole('supervisor') && $visit->employee->supervisor_id === $user->id);
    }
}