<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Role;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Fix: Bind Role class to container with proper namespace
        $this->app->bind(Role::class, function () {
            return new Role();
        });
        
        // Fix: Alias for 'role' (lowercase) that Laravel is looking for
        $this->app->alias(Role::class, 'role');
        
        // Also bind to Spatie's Role contract
        $this->app->bind(
            \Spatie\Permission\Contracts\Role::class,
            Role::class
        );
        
        // Bind the string 'role' to our Role class
        $this->app->bind('role', function ($app) {
            return $app->make(Role::class);
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Optional: Set model for permissions config
        \Spatie\Permission\PermissionRegistrar::class;
    }
}