<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        $admin = User::create([
            'name' => 'Admin User',
            'email' => 'admin@innovaxcess.com',
            'password' => Hash::make('password'),
            'phone' => '+201000000000',
            'employee_id' => 'ADM001',
            'status' => 'active',
            'hire_date' => now(),
        ]);

        $admin->assignRole('admin');

        // Create a supervisor
        $supervisor = User::create([
            'name' => 'Supervisor User',
            'email' => 'supervisor@innovaxcess.com',
            'password' => Hash::make('password'),
            'phone' => '+201000000001',
            'employee_id' => 'SUP001',
            'status' => 'active',
            'hire_date' => now(),
        ]);

        $supervisor->assignRole('supervisor');

        // Create an employee
        $employee = User::create([
            'name' => 'Employee User',
            'email' => 'employee@innovaxcess.com',
            'password' => Hash::make('password'),
            'phone' => '+201000000002',
            'employee_id' => 'EMP001',
            'supervisor_id' => $supervisor->id,
            'status' => 'active',
            'hire_date' => now(),
        ]);

        $employee->assignRole('employee');
    }
}