<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\Governorate;
use Illuminate\Database\Seeder;

class CitySeeder extends Seeder
{
    public function run()
    {
        $cities = [
            'Cairo' => [
                'Downtown Cairo', 'Zamalek', 'Maadi', 'Heliopolis', 'Nasr City',
                'New Cairo', '6th of October City', 'Sheikh Zayed City', 'Giza'
            ],
            'Giza' => [
                'Giza City', 'Dokki', 'Agouza', 'Haram', 'Faisal', 'Boulak Al Dakrour'
            ],
            'Alexandria' => [
                'Montaza', 'Raml Station', 'Sidi Gaber', 'Smouha', 'Miami', 'Stanley'
            ],
            'Dakahlia' => [
                'Mansoura', 'Talkha', 'Mit Ghamr', 'Aga', 'El Senbellawein'
            ],
            'Red Sea' => [
                'Hurghada', 'El Gouna', 'Safaga', 'Marsa Alam', 'Shalateen'
            ],
        ];

        foreach ($cities as $governorateName => $cityNames) {
            $governorate = Governorate::where('name', $governorateName)->first();
            
            if ($governorate) {
                foreach ($cityNames as $cityName) {
                    City::create([
                        'name' => $cityName,
                        'name_ar' => $cityName,
                        'governorate_id' => $governorate->id
                    ]);
                }
            }
        }
    }
}