<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RolePermissionSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions
        $permissions = [
            'view_dashboard',
            'manage_users',
            'manage_visits',
            'track_live_location',
            'manage_departments',
            'manage_clients',
            'manage_leaves',
            'manage_payroll',
            'view_reports',
            'manage_settings'
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // Create roles
        $adminRole = Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'web']);
        $supervisorRole = Role::firstOrCreate(['name' => 'supervisor', 'guard_name' => 'web']);
        $employeeRole = Role::firstOrCreate(['name' => 'employee', 'guard_name' => 'web']);

        // Assign all permissions to admin
        $adminRole->givePermissionTo(Permission::all());

        // Assign permissions to supervisor
        $supervisorPermissions = [
            'view_dashboard',
            'manage_visits',
            'track_live_location',
            'view_reports'
        ];
        $supervisorRole->givePermissionTo($supervisorPermissions);

        // Assign permissions to employee
        $employeePermissions = [
            'view_dashboard',
            'track_live_location'
        ];
        $employeeRole->givePermissionTo($employeePermissions);

        // Assign admin role to first user (if exists)
        $firstUser = User::first();
        if ($firstUser && !$firstUser->hasRole('admin')) {
            $firstUser->assignRole('admin');
        }

        echo "Roles and permissions seeded successfully!\n";
    }
}