<?php
// Health check script - accessible directly
header('Content-Type: application/json');

$checks = [
    'php_version' => PHP_VERSION,
    'laravel_installed' => file_exists(__DIR__ . '/../vendor/autoload.php'),
    'storage_writable' => is_writable(__DIR__ . '/../storage'),
    'bootstrap_writable' => is_writable(__DIR__ . '/../bootstrap/cache'),
    'env_exists' => file_exists(__DIR__ . '/../.env'),
];

// Database check if .env exists
if ($checks['env_exists']) {
    try {
        require __DIR__ . '/../vendor/autoload.php';
        $app = require_once __DIR__ . '/../bootstrap/app.php';
        $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
        
        $checks['database'] = DB::connection()->getPdo() ? 'connected' : 'failed';
        $checks['migrations'] = 'ok';
    } catch (Exception $e) {
        $checks['database'] = 'error: ' . $e->getMessage();
        $checks['migrations'] = 'error';
    }
}

$checks['server_software'] = $_SERVER['SERVER_SOFTWARE'] ?? 'unknown';
$checks['document_root'] = $_SERVER['DOCUMENT_ROOT'] ?? 'unknown';

echo json_encode([
    'status' => 'ok',
    'timestamp' => date('Y-m-d H:i:s'),
    'checks' => $checks,
    'message' => 'Place this file in your public folder and access it directly'
], JSON_PRETTY_PRINT);