@extends('layouts.dashboard')

@section('title', 'Add New Client')

@section('content')
<div class="container-fluid px-6 py-6">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col md:flex-row md:items-center justify-between mb-6">
            <div>
                <a href="{{ route('clients.index') }}" 
                   class="inline-flex items-center text-gray-600 hover:text-gray-900 font-medium mb-4 transition-colors duration-200 group">
                    <i class="fas fa-arrow-left mr-2 group-hover:-translate-x-1 transition-transform duration-200"></i> 
                    Back to Clients
                </a>
                <h1 class="text-2xl font-bold text-gray-900 mb-1">Add New Client</h1>
                <p class="text-gray-600">Add a new client to your organization</p>
            </div>
            <div class="mt-4 md:mt-0">
                <div class="bg-gradient-to-r from-green-500 to-teal-600 rounded-xl p-3 shadow">
                    <i class="fas fa-handshake text-white text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Container -->
    <div class="bg-white rounded-xl shadow border border-gray-100 overflow-hidden">
        <!-- Form Header -->
        <div class="px-8 py-4 border-b border-gray-100 bg-gray-50">
            <h2 class="text-xl font-bold text-gray-900">Client Information</h2>
            <p class="text-gray-600 text-sm mt-1">Enter the client details below</p>
        </div>

        <!-- Form -->
        <form action="{{ route('clients.store') }}" method="POST" id="clientForm" class="p-8">
            @csrf

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Left Column -->
                <div class="space-y-6">
                    <!-- Client Name -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-green-100 flex items-center justify-center mr-3">
                                <i class="fas fa-building text-green-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="name" class="block text-base font-semibold text-gray-900">
                                    Client Name
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>
                        </div>
                        <input type="text" 
                               id="name" 
                               name="name" 
                               value="{{ old('name') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                      focus:border-green-500 focus:ring-2 focus:ring-green-100 
                                      transition-all duration-300 @error('name') border-red-500 @enderror"
                               placeholder="Enter client name"
                               required>
                        @error('name')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Phone -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-blue-100 flex items-center justify-center mr-3">
                                <i class="fas fa-phone text-blue-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="phone" class="block text-base font-semibold text-gray-900">
                                    Phone Number
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>
                        </div>
                        <input type="tel" 
                               id="phone" 
                               name="phone" 
                               value="{{ old('phone') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                      focus:border-blue-500 focus:ring-2 focus:ring-blue-100 
                                      transition-all duration-300 @error('phone') border-red-500 @enderror"
                               placeholder="Enter phone number"
                               required>
                        @error('phone')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- GPS Coordinates - Latitude -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-yellow-100 flex items-center justify-center mr-3">
                                <i class="fas fa-globe-americas text-yellow-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="latitude" class="block text-base font-semibold text-gray-900">
                                    Latitude (Optional)
                                </label>
                            </div>
                        </div>
                        <div class="flex space-x-3">
                            <input type="number" 
                                   id="latitude" 
                                   name="latitude" 
                                   value="{{ old('latitude') }}"
                                   class="flex-1 px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                          focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 
                                          transition-all duration-300"
                                   placeholder="30.0444"
                                   step="0.000001">
                            <button type="button" 
                                    id="getLocationBtn"
                                    class="whitespace-nowrap px-4 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition duration-200 text-sm">
                                <i class="fas fa-crosshairs mr-2"></i> Get Location
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="space-y-6">
                    <!-- Governorate -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-purple-100 flex items-center justify-center mr-3">
                                <i class="fas fa-flag text-purple-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="governorate_id" class="block text-base font-semibold text-gray-900">
                                    Governorate
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>
                        </div>
                        <select id="governorate_id" 
                                name="governorate_id" 
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                       focus:border-purple-500 focus:ring-2 focus:ring-purple-100 
                                       transition-all duration-300 @error('governorate_id') border-red-500 @enderror"
                                required>
                            <option value="">Select Governorate</option>
                            @foreach($governorates as $governorate)
                                <option value="{{ $governorate->id }}" {{ old('governorate_id') == $governorate->id ? 'selected' : '' }}>
                                    {{ $governorate->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('governorate_id')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- City -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-purple-100 flex items-center justify-center mr-3">
                                <i class="fas fa-city text-purple-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="city_id" class="block text-base font-semibold text-gray-900">
                                    City
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>
                        </div>
                        <select id="city_id" 
                                name="city_id" 
                                class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                       focus:border-purple-500 focus:ring-2 focus:ring-purple-100 
                                       transition-all duration-300 @error('city_id') border-red-500 @enderror"
                                required>
                            <option value="">Select City</option>
                            @foreach($cities as $city)
                                <option value="{{ $city->id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>
                                    {{ $city->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('city_id')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Area -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-purple-100 flex items-center justify-center mr-3">
                                <i class="fas fa-map-marker text-purple-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="area" class="block text-base font-semibold text-gray-900">
                                    Area
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>
                        </div>
                        <input type="text" 
                               id="area" 
                               name="area" 
                               value="{{ old('area') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                      focus:border-purple-500 focus:ring-2 focus:ring-purple-100 
                                      transition-all duration-300 @error('area') border-red-500 @enderror"
                               placeholder="Enter area"
                               required>
                        @error('area')
                            <p class="mt-2 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- GPS Coordinates - Longitude -->
                    <div>
                        <div class="flex items-center mb-3">
                            <div class="w-8 h-8 rounded-lg bg-yellow-100 flex items-center justify-center mr-3">
                                <i class="fas fa-globe-americas text-yellow-600 text-sm"></i>
                            </div>
                            <div>
                                <label for="longitude" class="block text-base font-semibold text-gray-900">
                                    Longitude (Optional)
                                </label>
                            </div>
                        </div>
                        <input type="number" 
                               id="longitude" 
                               name="longitude" 
                               value="{{ old('longitude') }}"
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                      focus:border-yellow-500 focus:ring-2 focus:ring-yellow-100 
                                      transition-all duration-300"
                               placeholder="31.2357"
                               step="0.000001">
                    </div>
                </div>
            </div>

            <!-- Address -->
            <div class="mt-8 pt-8 border-t border-gray-200">
                <div class="flex items-center mb-6">
                    <div class="w-8 h-8 rounded-lg bg-purple-100 flex items-center justify-center mr-3">
                        <i class="fas fa-map-pin text-purple-600 text-sm"></i>
                    </div>
                    <div>
                        <label for="address" class="block text-base font-semibold text-gray-900">
                            Address (Optional)
                        </label>
                        <p class="text-sm text-gray-500 mt-1">Enter complete address details</p>
                    </div>
                </div>
                <textarea id="address" 
                          name="address" 
                          rows="2"
                          class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-base 
                                 focus:border-purple-500 focus:ring-2 focus:ring-purple-100 
                                 transition-all duration-300 @error('address') border-red-500 @enderror"
                          placeholder="Enter complete address">{{ old('address') }}</textarea>
                @error('address')
                    <p class="mt-2 text-sm text-red-600 flex items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                    </p>
                @enderror
            </div>

            <!-- Hidden Status Field (Default: Active) -->
            <input type="hidden" name="status" value="active">

            <!-- Form Actions -->
            <div class="mt-8 pt-8 border-t border-gray-200">
                <div class="flex flex-col sm:flex-row sm:items-center justify-between space-y-4 sm:space-y-0">
                    <div>
                        <p class="text-sm text-gray-500">
                            <span class="text-red-500">*</span> Required fields
                        </p>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="{{ route('clients.index') }}" 
                           class="inline-flex items-center justify-center px-5 py-2.5 border-2 border-gray-300 text-gray-700 font-semibold rounded-lg hover:bg-gray-50 
                                  hover:border-gray-400 transition-all duration-200 text-sm">
                            <i class="fas fa-times mr-2"></i> Cancel
                        </a>
                        <button type="submit" 
                                class="inline-flex items-center justify-center px-6 py-2.5 bg-gradient-to-r from-green-600 to-teal-600 text-white font-semibold rounded-lg 
                                       hover:from-green-700 hover:to-teal-700 
                                       transition-all duration-200 focus:ring-2 focus:ring-green-300 text-sm">
                            <i class="fas fa-plus-circle mr-2"></i> Create Client
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form elements
    const governorateSelect = document.getElementById('governorate_id');
    const citySelect = document.getElementById('city_id');
    const getLocationBtn = document.getElementById('getLocationBtn');
    const latitudeInput = document.getElementById('latitude');
    const longitudeInput = document.getElementById('longitude');
    
    // Get current location
    getLocationBtn.addEventListener('click', function() {
        if (navigator.geolocation) {
            getLocationBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Getting Location...';
            getLocationBtn.disabled = true;
            
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    latitudeInput.value = position.coords.latitude.toFixed(6);
                    longitudeInput.value = position.coords.longitude.toFixed(6);
                    getLocationBtn.innerHTML = '<i class="fas fa-crosshairs mr-2"></i> Get Location';
                    getLocationBtn.disabled = false;
                },
                function(error) {
                    alert('Unable to get your location. Please enter coordinates manually.');
                    getLocationBtn.innerHTML = '<i class="fas fa-crosshairs mr-2"></i> Get Location';
                    getLocationBtn.disabled = false;
                }
            );
        } else {
            alert('Geolocation is not supported by your browser.');
        }
    });
    
    // Load cities based on selected governorate
    governorateSelect.addEventListener('change', function() {
        const governorateId = this.value;
        
        if (governorateId) {
            fetch(`/clients/cities?governorate_id=${governorateId}`)
                .then(response => response.json())
                .then(data => {
                    citySelect.innerHTML = '<option value="">Select City</option>';
                    data.forEach(city => {
                        const option = document.createElement('option');
                        option.value = city.id;
                        option.textContent = city.name;
                        citySelect.appendChild(option);
                    });
                })
                .catch(error => console.error('Error fetching cities:', error));
        } else {
            citySelect.innerHTML = '<option value="">Select City</option>';
        }
    });
});
</script>
@endsection