@extends('layouts.dashboard')

@section('title', 'Add New Department')

@section('content')
<div class="container-fluid px-4 py-6 mx-auto max-w-7xl">
    <!-- Header -->
    <div class="mb-10">
        <div class="flex flex-col md:flex-row md:items-center justify-between mb-6">
            <div>
                <a href="{{ route('departments.index') }}" 
                   class="inline-flex items-center text-blue-600 hover:text-blue-700 font-medium mb-4 transition-colors duration-200 group">
                    <i class="fas fa-arrow-left mr-2 group-hover:-translate-x-1 transition-transform duration-200"></i> 
                    Back to Departments
                </a>
                <h1 class="text-3xl font-bold text-gray-900 mb-2">Create New Department</h1>
                <p class="text-gray-600 text-lg">Add a new department to organize your team structure</p>
            </div>
            <div class="mt-4 md:mt-0">
                <div class="bg-gradient-to-r from-blue-500 to-indigo-600 rounded-2xl p-4 shadow-lg">
                    <i class="fas fa-building text-white text-3xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Form Section -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-2xl shadow-xl border border-gray-100 overflow-hidden">
                <!-- Form Header -->
                <div class="px-8 py-6 border-b border-gray-100">
                    <h2 class="text-2xl font-bold text-gray-900">Department Details</h2>
                    <p class="text-gray-600 mt-1">Enter the department information below</p>
                </div>

                <!-- Form -->
                <form action="{{ route('departments.store') }}" method="POST" id="departmentForm" class="p-8">
                    @csrf

                    <!-- Department Name -->
                    <div class="mb-8">
                        <div class="flex items-center mb-4">
                            <div class="w-10 h-10 rounded-lg bg-blue-100 flex items-center justify-center mr-3">
                                <i class="fas fa-tag text-blue-600"></i>
                            </div>
                            <div>
                                <label for="name" class="block text-lg font-semibold text-gray-900">
                                    Department Name
                                    <span class="text-red-500 ml-1">*</span>
                                </label>
                            </div>
                        </div>
                        <div class="relative">
                            <input type="text" 
                                   id="name" 
                                   name="name" 
                                   value="{{ old('name') }}"
                                   class="w-full px-4 py-4 pl-12 border-2 border-gray-200 rounded-xl text-lg 
                                          focus:border-blue-500 focus:ring-4 focus:ring-blue-100 
                                          transition-all duration-300 @error('name') border-red-500 @enderror"
                                   placeholder="Enter department name"
                                   required>
                            <div class="absolute left-4 top-1/2 transform -translate-y-1/2">
                                <i class="fas fa-building text-gray-400"></i>
                            </div>
                        </div>
                        @error('name')
                            <div class="mt-3 p-3 bg-red-50 border border-red-200 rounded-lg">
                                <p class="text-red-600 flex items-center">
                                    <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                                </p>
                            </div>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div class="mb-8">
                        <div class="flex items-center mb-4">
                            <div class="w-10 h-10 rounded-lg bg-purple-100 flex items-center justify-center mr-3">
                                <i class="fas fa-align-left text-purple-600"></i>
                            </div>
                            <div>
                                <label for="description" class="block text-lg font-semibold text-gray-900">
                                    Description
                                </label>
                            </div>
                        </div>
                        <textarea id="description" 
                                  name="description" 
                                  rows="4"
                                  class="w-full px-4 py-4 border-2 border-gray-200 rounded-xl text-lg 
                                         focus:border-purple-500 focus:ring-4 focus:ring-purple-100 
                                         transition-all duration-300 @error('description') border-red-500 @enderror"
                                  placeholder="Brief description about the department's role and responsibilities...">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="mt-3 p-3 bg-red-50 border border-red-200 rounded-lg">
                                <p class="text-red-600 flex items-center">
                                    <i class="fas fa-exclamation-triangle mr-2"></i> {{ $message }}
                                </p>
                            </div>
                        @enderror
                    </div>

                    <!-- Status Selection -->
                    <div class="mb-10">
                        <div class="flex items-center mb-4">
                            <div class="w-10 h-10 rounded-lg bg-green-100 flex items-center justify-center mr-3">
                                <i class="fas fa-toggle-on text-green-600"></i>
                            </div>
                            <div>
                                <label class="block text-lg font-semibold text-gray-900">
                                    Status
                                </label>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <label class="relative">
                                <input type="radio" name="status" value="active" checked 
                                       class="sr-only peer">
                                <div class="flex items-center justify-center p-6 border-2 border-gray-200 rounded-xl cursor-pointer 
                                           peer-checked:border-green-500 peer-checked:bg-green-50 
                                           hover:bg-gray-50 transition-all duration-200">
                                    <div class="flex items-center">
                                        <div class="w-6 h-6 rounded-full border-2 border-gray-300 mr-3 
                                                   peer-checked:border-green-500 peer-checked:bg-green-500">
                                            <div class="w-full h-full rounded-full flex items-center justify-center">
                                                <i class="fas fa-check text-white text-xs opacity-0 peer-checked:opacity-100"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="font-semibold text-gray-900">Active</div>
                                            <div class="text-sm text-gray-500">Department is operational</div>
                                        </div>
                                    </div>
                                </div>
                            </label>
                            <label class="relative">
                                <input type="radio" name="status" value="inactive"
                                       class="sr-only peer">
                                <div class="flex items-center justify-center p-6 border-2 border-gray-200 rounded-xl cursor-pointer 
                                           peer-checked:border-red-500 peer-checked:bg-red-50 
                                           hover:bg-gray-50 transition-all duration-200">
                                    <div class="flex items-center">
                                        <div class="w-6 h-6 rounded-full border-2 border-gray-300 mr-3 
                                                   peer-checked:border-red-500 peer-checked:bg-red-500">
                                            <div class="w-full h-full rounded-full flex items-center justify-center">
                                                <i class="fas fa-check text-white text-xs opacity-0 peer-checked:opacity-100"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="font-semibold text-gray-900">Inactive</div>
                                            <div class="text-sm text-gray-500">Department is archived</div>
                                        </div>
                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>

                    <!-- Form Actions -->
                    <div class="pt-8 mt-8 border-t border-gray-200">
                        <div class="flex flex-col sm:flex-row sm:items-center justify-between space-y-4 sm:space-y-0">
                            <div>
                                <p class="text-sm text-gray-500">
                                    <span class="text-red-500">*</span> Required fields
                                </p>
                            </div>
                            <div class="flex items-center space-x-4">
                                <a href="{{ route('departments.index') }}" 
                                   class="inline-flex items-center justify-center px-6 py-3 border-2 border-gray-300 text-gray-700 font-semibold rounded-xl hover:bg-gray-50 
                                          hover:border-gray-400 transition-all duration-200">
                                    <i class="fas fa-times mr-2"></i> Cancel
                                </a>
                                <button type="submit" 
                                        class="inline-flex items-center justify-center px-8 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-semibold rounded-xl 
                                               hover:from-blue-700 hover:to-indigo-700 hover:shadow-lg 
                                               transition-all duration-200 focus:ring-4 focus:ring-blue-300">
                                    <i class="fas fa-plus-circle mr-2"></i> Create Department
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Preview & Stats Section -->
        <div class="lg:col-span-1">
            <!-- Preview Card -->
            <div class="bg-white rounded-2xl shadow-xl border border-gray-100 overflow-hidden mb-8">
                <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-gray-50 to-white">
                    <h3 class="text-xl font-bold text-gray-900 flex items-center">
                        <i class="fas fa-eye mr-2 text-blue-600"></i> Preview
                    </h3>
                </div>
                <div class="p-8">
                    <div class="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-2xl p-8 mb-8">
                        <div class="flex items-center mb-6">
                            <div class="w-20 h-20 rounded-2xl bg-gradient-to-r from-blue-500 to-indigo-600 flex items-center justify-center mr-6 shadow-lg">
                                <i class="fas fa-building text-white text-3xl"></i>
                            </div>
                            <div>
                                <h4 id="previewName" class="text-2xl font-bold text-gray-900">Department Name</h4>
                                <div class="flex items-center mt-2">
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800 mr-3">
                                        <i class="fas fa-circle mr-1 text-green-500" style="font-size: 8px;"></i>
                                        Active
                                    </span>
                                    <span class="text-gray-600">Preview</span>
                                </div>
                            </div>
                        </div>
                        <div class="space-y-4">
                            <div class="flex items-center p-4 bg-white rounded-xl shadow-sm">
                                <div class="w-12 h-12 rounded-lg bg-blue-100 flex items-center justify-center mr-4">
                                    <i class="fas fa-users text-blue-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Team Members</p>
                                    <p class="text-xl font-bold text-gray-900">0 employees</p>
                                </div>
                            </div>
                            <div class="flex items-center p-4 bg-white rounded-xl shadow-sm">
                                <div class="w-12 h-12 rounded-lg bg-purple-100 flex items-center justify-center mr-4">
                                    <i class="fas fa-calendar-alt text-purple-600"></i>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Created Date</p>
                                    <p class="text-xl font-bold text-gray-900">{{ now()->format('M d, Y') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Description Preview -->
                    <div class="mb-8">
                        <h4 class="text-lg font-semibold text-gray-900 mb-4">Description Preview</h4>
                        <div id="previewDescription" class="bg-gray-50 p-6 rounded-xl min-h-[150px]">
                            <p class="text-gray-700 italic">Department description will appear here...</p>
                        </div>
                    </div>

                    <!-- Quick Stats -->
                    <div class="bg-gradient-to-r from-gray-900 to-gray-800 rounded-2xl p-6 text-white">
                        <h4 class="text-lg font-semibold mb-6 text-white">Current Department Stats</h4>
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <div class="flex items-center mb-2">
                                    <div class="w-10 h-10 rounded-lg bg-white/10 flex items-center justify-center mr-3">
                                        <i class="fas fa-building"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm text-gray-300">Total Departments</p>
                                        <p class="text-2xl font-bold">{{ \App\Models\Department::count() }}</p>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="flex items-center mb-2">
                                    <div class="w-10 h-10 rounded-lg bg-white/10 flex items-center justify-center mr-3">
                                        <i class="fas fa-user-friends"></i>
                                    </div>
                                    <div>
                                        <p class="text-sm text-gray-300">Total Employees</p>
                                        <p class="text-2xl font-bold">{{ \App\Models\User::count() }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="bg-gradient-to-r from-indigo-50 to-blue-50 rounded-2xl border border-indigo-100 p-6">
                <h4 class="text-lg font-semibold text-gray-900 mb-4">Quick Actions</h4>
                <div class="space-y-4">
                    <a href="{{ route('departments.index') }}" 
                       class="flex items-center p-4 bg-white rounded-xl hover:shadow-md transition-all duration-200 group">
                        <div class="w-10 h-10 rounded-lg bg-blue-100 flex items-center justify-center mr-4 group-hover:bg-blue-200 transition-colors duration-200">
                            <i class="fas fa-list text-blue-600"></i>
                        </div>
                        <div class="flex-1">
                            <p class="font-medium text-gray-900">View All Departments</p>
                            <p class="text-sm text-gray-600">Browse existing departments</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400 group-hover:text-blue-600 transition-colors duration-200"></i>
                    </a>
                    <a href="#" onclick="document.getElementById('departmentForm').reset();" 
                       class="flex items-center p-4 bg-white rounded-xl hover:shadow-md transition-all duration-200 group">
                        <div class="w-10 h-10 rounded-lg bg-red-100 flex items-center justify-center mr-4 group-hover:bg-red-200 transition-colors duration-200">
                            <i class="fas fa-redo text-red-600"></i>
                        </div>
                        <div class="flex-1">
                            <p class="font-medium text-gray-900">Clear Form</p>
                            <p class="text-sm text-gray-600">Reset all fields</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Custom styles for simplified design */
    .bg-gradient-to-br {
        background-image: linear-gradient(to bottom right, var(--tw-gradient-stops));
    }
    
    /* Smooth transitions */
    .transition-all {
        transition-property: all;
    }
    
    /* Custom input focus effects */
    .focus\:ring-4:focus {
        --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
        --tw-ring-shadow: var(--tw-ring-inset) 0 0 0 calc(4px + var(--tw-ring-offset-width)) var(--tw-ring-color);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0 #0000);
    }
    
    /* Custom scrollbar */
    textarea::-webkit-scrollbar {
        width: 6px;
    }
    
    textarea::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }
    
    textarea::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 10px;
    }
    
    textarea::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Live preview updates
    const nameInput = document.getElementById('name');
    const descriptionInput = document.getElementById('description');
    const statusInputs = document.querySelectorAll('input[name="status"]');
    const previewName = document.getElementById('previewName');
    const previewDescription = document.getElementById('previewDescription');
    const previewStatus = document.querySelector('#previewDescription').previousElementSibling.querySelector('.bg-green-100');
    
    // Update preview on input
    function updatePreview() {
        // Update name
        if (nameInput.value.trim()) {
            previewName.textContent = nameInput.value;
        } else {
            previewName.textContent = 'Department Name';
        }
        
        // Update description
        if (descriptionInput.value.trim()) {
            previewDescription.innerHTML = `<p class="text-gray-700">${descriptionInput.value}</p>`;
        } else {
            previewDescription.innerHTML = `<p class="text-gray-700 italic">Department description will appear here...</p>`;
        }
        
        // Update status preview based on selected radio
        let status = 'active';
        statusInputs.forEach(input => {
            if (input.checked) {
                status = input.value;
            }
        });
        
        if (status === 'active') {
            previewStatus.className = 'inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800 mr-3';
            previewStatus.innerHTML = '<i class="fas fa-circle mr-1 text-green-500" style="font-size: 8px;"></i>Active';
        } else {
            previewStatus.className = 'inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-100 text-red-800 mr-3';
            previewStatus.innerHTML = '<i class="fas fa-circle mr-1 text-red-500" style="font-size: 8px;"></i>Inactive';
        }
    }
    
    // Add event listeners
    nameInput.addEventListener('input', updatePreview);
    descriptionInput.addEventListener('input', updatePreview);
    statusInputs.forEach(input => {
        input.addEventListener('change', updatePreview);
    });
    
    // Initialize preview
    updatePreview();
});
</script>
@endsection