@extends('layouts.dashboard')

@section('title', 'Live Tracking Dashboard')

@section('content')
<div class="container mx-auto px-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Live Tracking Dashboard</h1>
        <div class="flex space-x-3">
            <a href="{{ route('live-tracking.map') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded flex items-center">
                <i class="fas fa-map mr-2"></i> View Map
            </a>
            <a href="{{ route('live-tracking.employees') }}" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded flex items-center">
                <i class="fas fa-users mr-2"></i> All Employees
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4">
                    <i class="fas fa-user-check text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Active Employees</p>
                    <h3 class="text-2xl font-bold">{{ $activeEmployees->count() }}</h3>
                </div>
            </div>
        </div>
        
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4">
                    <i class="fas fa-map-marker-alt text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Active Visits</p>
                    <h3 class="text-2xl font-bold">{{ $activeVisits->count() }}</h3>
                </div>
            </div>
        </div>
        
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4">
                    <i class="fas fa-clock text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Today's Visits</p>
                    <h3 class="text-2xl font-bold">{{ \App\Models\Visit::whereDate('scheduled_date', today())->count() }}</h3>
                </div>
            </div>
        </div>
        
        <div class="bg-white shadow rounded-lg p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600 mr-4">
                    <i class="fas fa-exclamation-triangle text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Alerts</p>
                    <h3 class="text-2xl font-bold">
                        @php
                            // SAFELY check if scheduled_end column exists
                            if (\Schema::hasColumn('visits', 'scheduled_end')) {
                                echo \App\Models\Visit::where('scheduled_end', '<', now())->where('status', 'in_progress')->count();
                            } else {
                                // Fallback to using scheduled_date + duration logic
                                echo \App\Models\Visit::where('status', 'in_progress')
                                    ->where('last_location_update', '<', now()->subMinutes(30))
                                    ->count();
                            }
                        @endphp
                    </h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Employees Section -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Active Employees -->
        <div class="bg-white shadow-md rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-800">Currently Active Employees</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Employee</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Current Location</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Last Update</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($activeEmployees as $employee)
                        @php
                            $visit = $employee->visits->first();
                        @endphp
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <div class="h-10 w-10 rounded-full bg-blue-600 flex items-center justify-center text-white">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">{{ $employee->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $employee->employee_id }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-900">
                                    @if($visit && $visit->current_address)
                                        <i class="fas fa-map-marker-alt text-red-500 mr-1"></i>
                                        {{ Str::limit($visit->current_address, 30) }}
                                    @else
                                        <span class="text-gray-400">Not available</span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                @if($visit)
                                    {{ $visit->updated_at->diffForHumans() }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex space-x-2">
                                    @if($visit)
                                    <a href="{{ route('live-tracking.employee-location', $employee) }}" 
                                       class="text-blue-600 hover:text-blue-900"
                                       title="View Location">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </a>
                                    <a href="{{ route('gps.track', $visit->id ?? '#') }}" 
                                       class="text-green-600 hover:text-green-900"
                                       title="Track Visit">
                                        <i class="fas fa-satellite"></i>
                                    </a>
                                    <a href="{{ route('live-tracking.history', $employee) }}" 
                                       class="text-purple-600 hover:text-purple-900"
                                       title="View History">
                                        <i class="fas fa-history"></i>
                                    </a>
                                    @else
                                    <span class="text-gray-400">No active visit</span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center text-gray-500">
                                <i class="fas fa-users text-3xl mb-3"></i>
                                <p>No active employees at the moment</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Active Visits -->
        <div class="bg-white shadow-md rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-800">Active Visits</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Employee & Client</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Duration</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($activeVisits as $visit)
                        <tr>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900">{{ $visit->employee->name ?? 'Unknown' }}</div>
                                <div class="text-sm text-gray-500">
                                    <i class="fas fa-building mr-1"></i> {{ $visit->client->name ?? 'Unknown Client' }}
                                </div>
                                <div class="text-xs text-gray-400 mt-1">
                                    <i class="fas fa-clock mr-1"></i> {{ $visit->scheduled_date->format('H:i') }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                    <i class="fas fa-spinner fa-spin mr-1"></i> In Progress
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                @if($visit->started_at)
                                    {{ $visit->started_at->diffForHumans(null, true) }}
                                @else
                                    Not started
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <a href="{{ route('gps.track', $visit) }}" 
                                   class="text-blue-600 hover:text-blue-900 inline-flex items-center"
                                   title="Live Track">
                                    <i class="fas fa-satellite-dish mr-1"></i> Track
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center text-gray-500">
                                <i class="fas fa-map-marked-alt text-3xl mb-3"></i>
                                <p>No active visits at the moment</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="mt-6 grid grid-cols-1 md:grid-cols-3 gap-6">
        <a href="{{ route('live-tracking.map') }}" class="bg-white shadow rounded-lg p-6 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4">
                    <i class="fas fa-map text-2xl"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">Live Map View</h3>
                    <p class="text-sm text-gray-600">View all active employees on an interactive map</p>
                </div>
            </div>
        </a>
        
        <a href="{{ route('live-tracking.employees') }}" class="bg-white shadow rounded-lg p-6 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4">
                    <i class="fas fa-users text-2xl"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">All Employees</h3>
                    <p class="text-sm text-gray-600">Browse all employees with tracking information</p>
                </div>
            </div>
        </a>
        
        <a href="{{ route('live-tracking.alerts') }}" class="bg-white shadow rounded-lg p-6 hover:shadow-lg transition-shadow">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-red-100 text-red-600 mr-4">
                    <i class="fas fa-exclamation-triangle text-2xl"></i>
                </div>
                <div>
                    <h3 class="text-lg font-semibold text-gray-800">Alerts & Notifications</h3>
                    <p class="text-sm text-gray-600">View tracking alerts and notifications</p>
                </div>
            </div>
        </a>
    </div>
</div>

<!-- Auto Refresh Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-refresh every 30 seconds
    setInterval(function() {
        fetch('{{ route("live-tracking.active-employees") }}')
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update the active employees count
                    const activeCountElement = document.querySelector('.bg-blue-100 + div h3');
                    if (activeCountElement) {
                        activeCountElement.textContent = data.count;
                    }
                }
            });
    }, 30000);
});
</script>
@endsection