@extends('layouts.dashboard')

@section('title', 'Edit Payroll')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Edit Payroll</h1>
                    <p class="text-gray-600 mt-1">Edit payroll record for {{ $payroll->employee->name }}</p>
                </div>
                <a href="{{ route('payrolls.index') }}" 
                   class="btn-secondary inline-flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i> Back to Payrolls
                </a>
            </div>
        </div>

        @if($payroll->status !== 'draft')
        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-triangle text-yellow-600 mr-3"></i>
                <div>
                    <p class="font-medium text-yellow-800">This payroll cannot be edited</p>
                    <p class="text-yellow-700 text-sm mt-1">Only payrolls with "draft" status can be edited. Current status: <span class="font-bold">{{ ucfirst($payroll->status) }}</span></p>
                </div>
            </div>
        </div>
        @endif

        <!-- Form -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <form action="{{ route('payrolls.update', $payroll) }}" method="POST" id="payrollForm">
                @csrf
                @method('PUT')
                
                <div class="p-6 @if($payroll->status !== 'draft') opacity-50 pointer-events-none @endif">
                    <!-- Employee Display (Read-only when not draft) -->
                    <div class="mb-6">
                        <label class="form-label">Employee</label>
                        @if($payroll->status === 'draft')
                        <select name="employee_id" 
                                id="employee_id" 
                                class="form-select"
                                required>
                            @foreach($employees as $employee)
                            <option value="{{ $employee->id }}" {{ $payroll->employee_id == $employee->id ? 'selected' : '' }}>
                                {{ $employee->name }} ({{ $employee->employee_id ?? 'N/A' }})
                            </option>
                            @endforeach
                        </select>
                        @else
                        <div class="p-3 bg-gray-50 rounded-lg border border-gray-200">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-r from-blue-400 to-blue-500 flex items-center justify-center mr-3">
                                    <i class="fas fa-user text-white"></i>
                                </div>
                                <div>
                                    <p class="font-medium">{{ $payroll->employee->name }}</p>
                                    <p class="text-sm text-gray-500">{{ $payroll->employee->employee_id ?? 'N/A' }}</p>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- ... Rest of form similar to create.blade.php but with $payroll->field values ... -->
                    
                </div>

                <!-- Form Actions -->
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-100 flex justify-between items-center">
                    <div class="text-sm text-gray-500">
                        <i class="fas fa-info-circle mr-1"></i> 
                        @if($payroll->status === 'draft')
                        Payroll can be edited and saved as draft
                        @else
                        Payroll is {{ $payroll->status }} and cannot be edited
                        @endif
                    </div>
                    <div class="flex space-x-3">
                        <a href="{{ route('payrolls.index') }}" 
                           class="btn-secondary">
                            Cancel
                        </a>
                        @if($payroll->status === 'draft')
                        <button type="submit" 
                                class="btn-primary">
                            <i class="fas fa-save mr-2"></i> Update Payroll
                        </button>
                        @else
                        <a href="{{ route('payrolls.show', $payroll) }}" 
                           class="btn-primary">
                            <i class="fas fa-eye mr-2"></i> View Payroll
                        </a>
                        @endif
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Similar JavaScript to create.blade.php for salary calculation
</script>
@endsection