<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;

// Guest routes (not logged in)
Route::middleware('guest')->group(function () {
    // Login routes
    Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('login', [LoginController::class, 'login']);
    
    // Registration (disabled - uncomment if needed)
    // Route::get('register', function () {
    //     return redirect('/login');
    // })->name('register');
    
    // Password reset (disabled - uncomment if needed)
    // Route::get('forgot-password', function () {
    //     return view('auth.passwords.email');
    // })->name('password.request');
});

// Authenticated routes (logged in)
Route::middleware('auth')->group(function () {
    // Logout
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
});