// app/Http/Controllers/Supervisor/SupervisorDashboardController.php
<?php

namespace App\Http\Controllers\Supervisor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Visit;
use App\Models\LeaveRequest;

class SupervisorDashboardController extends Controller
{
    public function index()
    {
        $supervisor = Auth::user();
        
        // Get team members (employees assigned to this supervisor)
        $teamMembers = User::where('supervisor_id', $supervisor->id)
            ->orWhere('department_id', $supervisor->department_id)
            ->where('role', 'employee')
            ->get();
        
        // Today's visits for the team
        $todayVisits = Visit::whereIn('employee_id', $teamMembers->pluck('id'))
            ->whereDate('scheduled_date', today())
            ->orderBy('scheduled_time')
            ->get();
        
        // Pending leave requests
        $pendingLeaves = LeaveRequest::whereIn('employee_id', $teamMembers->pluck('id'))
            ->where('status', 'pending')
            ->count();
        
        // Active visits (in progress)
        $activeVisits = Visit::whereIn('employee_id', $teamMembers->pluck('id'))
            ->where('status', 'started')
            ->count();
        
        return view('supervisor.dashboard', compact(
            'teamMembers',
            'todayVisits',
            'pendingLeaves',
            'activeVisits'
        ));
    }
    
    public function team()
    {
        $supervisor = Auth::user();
        
        $teamMembers = User::where('supervisor_id', $supervisor->id)
            ->orWhere('department_id', $supervisor->department_id)
            ->where('role', 'employee')
            ->with(['department', 'todayAttendance'])
            ->paginate(15);
        
        return view('supervisor.team.index', compact('teamMembers'));
    }
}