<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'name_ar', 'governorate_id'];

    public function governorate()
    {
        return $this->belongsTo(Governorate::class);
    }

    public function clients()
    {
        return $this->hasMany(Client::class);
    }

    public function visits()
    {
        return $this->hasMany(Visit::class);
    }
}