<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name', 'contact_person', 'phone', 'email', 'governorate_id', 
        'city_id', 'area', 'latitude', 'longitude', 'address', 'status'
    ];

    protected $casts = [
        'status' => 'string'
    ];

    public function governorate()
    {
        return $this->belongsTo(Governorate::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function visits()
    {
        return $this->hasMany(Visit::class);
    }
}