<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('visits', function (Blueprint $table) {
            if (!Schema::hasColumn('visits', 'scheduled_end')) {
                $table->timestamp('scheduled_end')->nullable()->after('scheduled_time');
            }
            
            if (!Schema::hasColumn('visits', 'current_latitude')) {
                $table->decimal('current_latitude', 10, 8)->nullable()->after('longitude');
            }
            
            if (!Schema::hasColumn('visits', 'current_longitude')) {
                $table->decimal('current_longitude', 11, 8)->nullable()->after('current_latitude');
            }
            
            if (!Schema::hasColumn('visits', 'current_address')) {
                $table->text('current_address')->nullable()->after('current_longitude');
            }
        });
    }

    public function down()
    {
        Schema::table('visits', function (Blueprint $table) {
            $table->dropColumn(['scheduled_end', 'current_latitude', 'current_longitude', 'current_address']);
        });
    }
};