<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Spatie\Permission\Models\Role;

class AdminUserSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Creating/updating test users with Spatie roles...');

        // First, make sure roles exist
        $adminRole = Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'web']);
        $supervisorRole = Role::firstOrCreate(['name' => 'supervisor', 'guard_name' => 'web']);
        $employeeRole = Role::firstOrCreate(['name' => 'employee', 'guard_name' => 'web']);

        // Create or update admin user
        $admin = User::updateOrCreate(
            ['email' => 'admin@innovaxcess.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('password123'),
                'phone' => '+201000000000',
                'employee_id' => 'ADM001',
                'status' => 'active',
                'hire_date' => Carbon::now(),
                'department_id' => 1,
            ]
        );

        // Assign admin role using Spatie
        if (!$admin->hasRole('admin')) {
            $admin->assignRole('admin');
        }

        // Create or update supervisor user
        $supervisor = User::updateOrCreate(
            ['email' => 'supervisor@innovaxcess.com'],
            [
                'name' => 'Test Supervisor',
                'password' => Hash::make('password123'),
                'phone' => '+201000000002',
                'employee_id' => 'SUP001',
                'status' => 'active',
                'hire_date' => Carbon::now(),
                'department_id' => 1,
            ]
        );

        // Assign supervisor role
        if (!$supervisor->hasRole('supervisor')) {
            $supervisor->assignRole('supervisor');
        }

        // Create or update employee user
        $employee = User::updateOrCreate(
            ['email' => 'employee@innovaxcess.com'],
            [
                'name' => 'Test Employee',
                'password' => Hash::make('password123'),
                'phone' => '+201000000001',
                'employee_id' => 'EMP001',
                'status' => 'active',
                'hire_date' => Carbon::now(),
                'department_id' => 1,
                'supervisor_id' => $supervisor->id,
            ]
        );

        // Assign employee role
        if (!$employee->hasRole('employee')) {
            $employee->assignRole('employee');
        }

        // Create a department if none exists
        if (!\App\Models\Department::exists()) {
            \App\Models\Department::create([
                'name' => 'Field Operations',
                'description' => 'Field employees and visits management',
            ]);
            $this->command->info('Created default department: Field Operations');
        }

        $this->command->info('Test users created/updated successfully with Spatie roles!');
        $this->command->info('Admin: admin@innovaxcess.com / password123');
        $this->command->info('Employee: employee@innovaxcess.com / password123');
        $this->command->info('Supervisor: supervisor@innovaxcess.com / password123');
        
        // Verify roles were assigned
        $this->command->info("\nRole assignments:");
        $this->command->info("Admin has role admin: " . ($admin->hasRole('admin') ? 'YES' : 'NO'));
        $this->command->info("Supervisor has role supervisor: " . ($supervisor->hasRole('supervisor') ? 'YES' : 'NO'));
        $this->command->info("Employee has role employee: " . ($employee->hasRole('employee') ? 'YES' : 'NO'));
    }
}
