<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EgyptCitiesSeeder extends Seeder
{
    public function run()
    {
        $this->command->info('Seeding Egyptian governorates and cities...');
        
        $egyptGovernorates = [
            'Cairo' => [
                'Nasr City', 'Heliopolis', 'Maadi', 'Zamalek', 'Dokki', 'Mohandessin',
                '6th of October City', 'Sheikh Zayed City', 'New Cairo', 'Shubra',
                'Ain Shams', 'El Marg', 'El Matareya', 'El Basatin', 'El Salam'
            ],
            'Alexandria' => [
                'Montaza', 'Smouha', 'Sidi Gaber', 'Miami', 'Stanley', 'Gleem',
                'Camp Caesar', 'Bolkly', 'Roushdy', 'Loran', 'Kafr Abdo', 'Saba Pasha'
            ],
            'Giza' => [
                'Dokki', 'Agouza', 'Mohandessin', 'Faisal', 'Haram', 'Omraniya',
                'Boulak Al Dakrour', 'Warraq', 'Imbaba', 'Kit Kat', 'Moneeb'
            ],
            'Qalyubia' => [
                'Banha', 'Qalyub', 'Shubra El Kheima', 'Khanka', 'Kafr Shukr',
                'Tukh', 'Qaha', 'Khusus', 'Shibin El Qanater'
            ],
            'Port Said' => [
                'Port Fouad', 'Al Arab', 'Al Dawahi', 'Al Manakh', 'Al Sharq'
            ],
            'Suez' => [
                'Suez', 'Arbaeen', 'Al Ganayen', 'Faisal', 'Attaka'
            ],
            'Damietta' => [
                'Damietta', 'Ras El Bar', 'Faraskour', 'Kafr Saad', 'Zarqa'
            ],
            'Dakahlia' => [
                'Mansoura', 'Mit Ghamr', 'Aga', 'El Senbellawein', 'Talkha'
            ],
            'Sharqia' => [
                'Zagazig', '10th of Ramadan City', 'Minya Al Qamh', 'Belbeis',
                'Mashtool', 'Al Qurein', 'Abu Hammad', 'Abu Kebir'
            ],
            'Monufia' => [
                'Shibin El Kom', 'Menouf', 'Sadat City', 'Ashmoun', 'Bagour'
            ],
            'Beheira' => [
                'Damanhur', 'Kafr El Dawwar', 'Rashid', 'Edku', 'Abu El Matamir'
            ],
            'Ismailia' => [
                'Ismailia', 'Fayed', 'Qantara', 'Abu Suwir', 'Tall al Kabir'
            ],
            'Gharbia' => [
                'Tanta', 'El Mahalla El Kubra', 'Kafr El Zayat', 'Zefta', 'Basyoun'
            ],
            'Kafr El Sheikh' => [
                'Kafr El Sheikh', 'Desouk', 'Fuwwah', 'Bila', 'El Reyad'
            ],
            'Minya' => [
                'Minya', 'Beni Mazar', 'Matay', 'Samalut', 'Maghagha'
            ],
            'Asyut' => [
                'Asyut', 'Dairut', 'Abnoub', 'El Qusiya', 'Manfalut'
            ],
            'Sohag' => [
                'Sohag', 'Akhmim', 'El Balyana', 'El Maragha', 'Juhayna'
            ],
            'Qena' => [
                'Qena', 'Naqada', 'Qus', 'Farshut', 'Abu Tesht'
            ],
            'Luxor' => [
                'Luxor', 'Armant', 'Esna', 'Tiba', 'Al Bayadiyah'
            ],
            'Aswan' => [
                'Aswan', 'Kom Ombo', 'Daraw', 'Nasr Al Nuba', 'Kalabsha'
            ],
            'Red Sea' => [
                'Hurghada', 'Ras Ghareb', 'Safaga', 'El Qoseir', 'Marsa Alam'
            ],
            'New Valley' => [
                'Kharga', 'Dakhla', 'Farafra', 'Baris', 'Mut'
            ],
            'Matrouh' => [
                'Marsa Matrouh', 'El Hamam', 'El Negaila', 'Sidi Barrani', 'Siwa'
            ],
            'North Sinai' => [
                'Arish', 'Sheikh Zuweid', 'Rafah', 'Bir al-Abd', 'Nakhl'
            ],
            'South Sinai' => [
                'El Tor', 'Sharm El Sheikh', 'Dahab', 'Nuweiba', 'Ras Sidr'
            ]
        ];

        $totalGovernorates = 0;
        $totalCities = 0;

        foreach ($egyptGovernorates as $governorateName => $cities) {
            // Check if governorate already exists
            $governorate = DB::table('governorates')
                ->where('name', $governorateName)
                ->first();
            
            if (!$governorate) {
                // Insert new governorate
                $governorateId = DB::table('governorates')->insertGetId([
                    'name' => $governorateName,
                    'name_ar' => $governorateName, // Same as English for now
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
                $totalGovernorates++;
                $this->command->info("Added governorate: $governorateName");
            } else {
                $governorateId = $governorate->id;
            }
            
            // Insert cities for this governorate
            foreach ($cities as $cityName) {
                // Check if city already exists
                $exists = DB::table('cities')
                    ->where('governorate_id', $governorateId)
                    ->where('name', $cityName)
                    ->exists();
                
                if (!$exists) {
                    DB::table('cities')->insert([
                        'name' => $cityName,
                        'name_ar' => $cityName, // Same as English for now
                        'governorate_id' => $governorateId,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                    $totalCities++;
                }
            }
        }
        
        $this->command->info("Seeding complete!");
        $this->command->info("Total governorates added: $totalGovernorates");
        $this->command->info("Total cities added: $totalCities");
        
        // Show summary
        $govCount = DB::table('governorates')->count();
        $cityCount = DB::table('cities')->count();
        $this->command->info("Total governorates in database: $govCount");
        $this->command->info("Total cities in database: $cityCount");
    }
}
