<?php

namespace Database\Seeders;

use App\Models\Governorate;
use Illuminate\Database\Seeder;

class GovernorateSeeder extends Seeder
{
    public function run()
    {
        $governorates = [
            ['name' => 'Cairo', 'name_ar' => 'القاهرة'],
            ['name' => 'Giza', 'name_ar' => 'الجيزة'],
            ['name' => 'Alexandria', 'name_ar' => 'الإسكندرية'],
            ['name' => 'Dakahlia', 'name_ar' => 'الدقهلية'],
            ['name' => 'Red Sea', 'name_ar' => 'البحر الأحمر'],
            ['name' => 'Beheira', 'name_ar' => 'البحيرة'],
            ['name' => 'Fayoum', 'name_ar' => 'الفيوم'],
            ['name' => 'Gharbiya', 'name_ar' => 'الغربية'],
            ['name' => 'Ismailia', 'name_ar' => 'الإسماعيلية'],
            ['name' => 'Menofia', 'name_ar' => 'المنوفية'],
            ['name' => 'Minya', 'name_ar' => 'المنيا'],
            ['name' => 'Qaliubiya', 'name_ar' => 'القليوبية'],
            ['name' => 'New Valley', 'name_ar' => 'الوادي الجديد'],
            ['name' => 'Suez', 'name_ar' => 'السويس'],
            ['name' => 'Aswan', 'name_ar' => 'أسوان'],
            ['name' => 'Assiut', 'name_ar' => 'أسيوط'],
            ['name' => 'Beni Suef', 'name_ar' => 'بني سويف'],
            ['name' => 'Port Said', 'name_ar' => 'بورسعيد'],
            ['name' => 'Damietta', 'name_ar' => 'دمياط'],
            ['name' => 'Sharkia', 'name_ar' => 'الشرقية'],
            ['name' => 'South Sinai', 'name_ar' => 'جنوب سيناء'],
            ['name' => 'Kafr El Sheikh', 'name_ar' => 'كفر الشيخ'],
            ['name' => 'Matrouh', 'name_ar' => 'مطروح'],
            ['name' => 'Luxor', 'name_ar' => 'الأقصر'],
            ['name' => 'Qena', 'name_ar' => 'قنا'],
            ['name' => 'North Sinai', 'name_ar' => 'شمال سيناء'],
            ['name' => 'Sohag', 'name_ar' => 'سوهاج'],
        ];

        foreach ($governorates as $governorate) {
            Governorate::create($governorate);
        }
    }
}