<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    public function run()
    {
        // Create permissions
        $permissions = [
            'user_management',
            'department_management',
            'client_management',
            'visit_management',
            'leave_management',
            'payroll_management',
            'report_management',
            'assign_visits',
            'approve_leaves',
            'view_visits',
            'request_leave'
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles and assign permissions
        $admin = Role::create(['name' => 'admin']);
        $admin->givePermissionTo([
            'user_management',
            'department_management',
            'client_management',
            'visit_management',
            'leave_management',
            'payroll_management',
            'report_management'
        ]);

        $supervisor = Role::create(['name' => 'supervisor']);
        $supervisor->givePermissionTo([
            'assign_visits',
            'approve_leaves',
            'view_visits'
        ]);

        $employee = Role::create(['name' => 'employee']);
        $employee->givePermissionTo([
            'view_visits',
            'request_leave'
        ]);
    }
}