<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class SimpleRoleSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create roles
        $adminRole = Role::firstOrCreate(['name' => 'admin', 'guard_name' => 'web']);
        $supervisorRole = Role::firstOrCreate(['name' => 'supervisor', 'guard_name' => 'web']);
        $employeeRole = Role::firstOrCreate(['name' => 'employee', 'guard_name' => 'web']);

        // Create permissions
        $permissions = [
            // Admin permissions
            'view dashboard',
            'manage users',
            'manage departments',
            'manage governorates',
            'manage cities',
            'manage clients',
            'manage visits',
            'manage leave requests',
            'manage payroll',
            'view reports',
            'manage settings',
            
            // Supervisor permissions
            'view team',
            'assign visits',
            'monitor visits',
            'approve leaves',
            'view team reports',
            
            // Employee permissions
            'view my visits',
            'start visit',
            'complete visit',
            'check in',
            'check out',
            'request leave',
            'view my payroll',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // Assign all permissions to admin
        $adminRole->givePermissionTo(Permission::all());

        // Assign supervisor permissions
        $supervisorPermissions = [
            'view dashboard',
            'view team',
            'assign visits',
            'monitor visits',
            'approve leaves',
            'view team reports',
        ];
        $supervisorRole->givePermissionTo($supervisorPermissions);

        // Assign employee permissions
        $employeePermissions = [
            'view dashboard',
            'view my visits',
            'start visit',
            'complete visit',
            'check in',
            'check out',
            'request leave',
            'view my payroll',
        ];
        $employeeRole->givePermissionTo($employeePermissions);

        $this->command->info('Roles and permissions created successfully!');
        $this->command->info('Roles: admin, supervisor, employee');
    }
}
