<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "<h3>Fixing 419 Error...</h3>";

try {
    // 1. Clear all caches
    echo "Clearing caches...<br>";
    \Artisan::call('cache:clear');
    \Artisan::call('config:clear');
    \Artisan::call('view:clear');
    \Artisan::call('route:clear');
    \Artisan::call('optimize:clear');
    echo "✓ Caches cleared<br>";
    
    // 2. Generate new app key if needed
    $currentKey = config('app.key');
    if (empty($currentKey) || strpos($currentKey, 'base64:') === false) {
        echo "Regenerating app key...<br>";
        \Artisan::call('key:generate', ['--force' => true]);
        echo "✓ App key regenerated<br>";
    } else {
        echo "✓ App key exists: " . substr($currentKey, 0, 20) . "...<br>";
    }
    
    // 3. Check session configuration
    echo "Checking session config...<br>";
    echo "Session driver: " . config('session.driver') . "<br>";
    echo "Session lifetime: " . config('session.lifetime') . " minutes<br>";
    
    // 4. Create sessions directory if it doesn't exist
    $sessionPath = storage_path('framework/sessions');
    if (!is_dir($sessionPath)) {
        mkdir($sessionPath, 0755, true);
        echo "✓ Created sessions directory<br>";
    }
    
    // 5. Fix permissions
    chmod(storage_path(), 0755);
    chmod(bootstrap_path('cache'), 0755);
    echo "✓ Fixed permissions<br>";
    
    echo "<h4 style='color: green;'>✓ Fix applied successfully!</h4>";
    echo "<p>Try logging in now: <a href='/login'>/login</a></p>";
    
} catch (Exception $e) {
    echo "<h4 style='color: red;'>Error:</h4>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
?>