<?php
// Quick fix script to check web root configuration
echo "Checking web server configuration...\n\n";

// Check current directory
echo "Current directory: " . __DIR__ . "\n";

// Check if public/index.php exists
$publicIndex = __DIR__ . '/public/index.php';
if (file_exists($publicIndex)) {
    echo "✓ public/index.php exists\n";
    
    // Read first few lines
    $content = file_get_contents($publicIndex, false, null, 0, 500);
    if (strpos($content, 'Laravel') !== false) {
        echo "✓ Laravel index.php detected\n";
    } else {
        echo "✗ Wrong index.php content\n";
    }
} else {
    echo "✗ public/index.php NOT FOUND\n";
}

// Check .env
$envFile = __DIR__ . '/.env';
if (file_exists($envFile)) {
    echo "✓ .env file exists\n";
    
    $envContent = file_get_contents($envFile);
    if (strpos($envContent, 'APP_URL=https://gps.innoverahub.com') !== false) {
        echo "✓ APP_URL correctly set\n";
    } else {
        echo "✗ APP_URL not set to https://gps.innoverahub.com\n";
    }
} else {
    echo "✗ .env file NOT FOUND\n";
}

// Check storage permissions
$storageDir = __DIR__ . '/storage';
if (is_writable($storageDir)) {
    echo "✓ Storage directory is writable\n";
} else {
    echo "✗ Storage directory is NOT writable\n";
}

echo "\n=== RECOMMENDATION ===\n";
echo "1. Point your web server (Apache/Nginx) to: " . __DIR__ . "/public\n";
echo "2. Restart your web server\n";
echo "3. Clear browser cache\n";
echo "4. Visit: https://gps.innoverahub.com\n";