@extends('layouts.employee')

@section('title', 'My Visits')

@section('content')
<div class="py-6">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">My Visits</h1>
            <p class="text-gray-600">All your scheduled and completed visits</p>
        </div>
        <div class="flex items-center space-x-3">
            <div class="relative">
                <input type="text" 
                       id="searchVisits" 
                       placeholder="Search visits..." 
                       class="form-input pl-10 pr-4 py-2">
                <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
            </div>
            <select id="filterStatus" class="form-select py-2">
                <option value="">All Status</option>
                <option value="scheduled">Scheduled</option>
                <option value="in_progress">In Progress</option>
                <option value="completed">Completed</option>
                <option value="cancelled">Cancelled</option>
            </select>
        </div>
    </div>

    <!-- Visits Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Client
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Date & Time
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Location
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($visits as $visit)
                    <tr class="hover:bg-gray-50 transition duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="w-8 h-8 rounded-full bg-gradient-to-r from-blue-500 to-blue-600 flex items-center justify-center mr-3">
                                    <i class="fas fa-building text-white text-sm"></i>
                                </div>
                                <div>
                                    <div class="font-medium text-gray-900">{{ $visit->client->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $visit->purpose }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">{{ $visit->scheduled_date->format('M d, Y') }}</div>
                            <div class="text-sm text-gray-500">{{ $visit->scheduled_time }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">{{ $visit->client->city->name ?? 'N/A' }}</div>
                            <div class="text-sm text-gray-500">{{ $visit->client->area }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $statusColors = [
                                    'scheduled' => 'bg-yellow-100 text-yellow-800',
                                    'in_progress' => 'bg-blue-100 text-blue-800',
                                    'completed' => 'bg-green-100 text-green-800',
                                    'cancelled' => 'bg-red-100 text-red-800'
                                ];
                            @endphp
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium {{ $statusColors[$visit->status] }}">
                                {{ str_replace('_', ' ', ucfirst($visit->status)) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-2">
                                @if($visit->status == 'scheduled')
                                <form action="{{ route('employee.visits.start', $visit) }}" method="POST">
                                    @csrf
                                    <button type="submit" 
                                            class="inline-flex items-center px-3 py-1 bg-green-600 hover:bg-green-700 text-white text-sm rounded">
                                        <i class="fas fa-play-circle mr-1"></i> Start
                                    </button>
                                </form>
                                @endif
                                
                                @if($visit->status == 'in_progress')
                                <button onclick="showCompleteModal({{ $visit->id }})"
                                        class="inline-flex items-center px-3 py-1 bg-purple-600 hover:bg-purple-700 text-white text-sm rounded">
                                    <i class="fas fa-check-circle mr-1"></i> Complete
                                </button>
                                @endif
                                
                                <a href="{{ route('employee.visits.show', $visit) }}" 
                                   class="inline-flex items-center px-3 py-1 bg-blue-600 hover:bg-blue-700 text-white text-sm rounded">
                                    <i class="fas fa-eye mr-1"></i> View
                                </a>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center">
                            <i class="fas fa-calendar-times text-gray-300 text-4xl mb-3"></i>
                            <p class="text-gray-500">No visits found</p>
                            <p class="text-sm text-gray-400 mt-1">Your supervisor will assign visits to you.</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        @if($visits->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $visits->links() }}
        </div>
        @endif
    </div>
</div>

<!-- Complete Visit Modal -->
<div id="completeModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-1/3 shadow-lg rounded-xl bg-white">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-gray-800">Complete Visit</h3>
            <button onclick="closeCompleteModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        
        <form id="completeForm" method="POST">
            @csrf
            <div class="mb-4">
                <label class="form-label">Visit Notes</label>
                <textarea name="employee_notes" 
                          rows="4"
                          class="form-input"
                          placeholder="Add notes about the visit, client feedback, or any issues encountered..."></textarea>
            </div>
            
            <div class="flex justify-end space-x-3">
                <button type="button" 
                        onclick="closeCompleteModal()" 
                        class="btn-secondary">
                    Cancel
                </button>
                <button type="submit" 
                        class="btn-primary">
                    <i class="fas fa-check-circle mr-2"></i> Complete Visit
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function showCompleteModal(visitId) {
    const modal = document.getElementById('completeModal');
    const form = document.getElementById('completeForm');
    
    form.action = `/employee/visits/${visitId}/complete`;
    modal.classList.remove('hidden');
}

function closeCompleteModal() {
    document.getElementById('completeModal').classList.add('hidden');
}
</script>
@endsection
