{{-- resources/views/supervisor/dashboard.blade.php --}}
@extends('layouts.supervisor')

@section('content')
<div class="container-fluid px-4 py-6">
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">Supervisor Dashboard</h1>
        <p class="text-gray-600">Welcome, {{ Auth::user()->name }}</p>
    </div>

    <!-- Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                    <i class="fas fa-users"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Team Members</p>
                    <p class="text-xl font-bold">{{ $teamMembers->count() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Today's Visits</p>
                    <p class="text-xl font-bold">{{ $todayVisits->count() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Active Visits</p>
                    <p class="text-xl font-bold">{{ $activeVisits }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-gray-600">Pending Leaves</p>
                    <p class="text-xl font-bold">{{ $pendingLeaves }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <a href="{{ route('supervisor.team') }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="font-medium">Team Management</h3>
                    <p class="text-sm text-gray-600">View team members</p>
                </div>
                <i class="fas fa-arrow-right text-gray-400"></i>
            </div>
        </a>

        <a href="{{ route('supervisor.visits.index') }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="font-medium">Assign Visits</h3>
                    <p class="text-sm text-gray-600">Schedule new visits</p>
                </div>
                <i class="fas fa-arrow-right text-gray-400"></i>
            </div>
        </a>

        <a href="{{ route('supervisor.tracking') }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="font-medium">Live Tracking</h3>
                    <p class="text-sm text-gray-600">Monitor active visits</p>
                </div>
                <i class="fas fa-arrow-right text-gray-400"></i>
            </div>
        </a>

        <a href="{{ route('supervisor.leaves.index') }}" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="font-medium">Leave Requests</h3>
                    <p class="text-sm text-gray-600">Approve/reject leaves</p>
                </div>
                <i class="fas fa-arrow-right text-gray-400"></i>
            </div>
        </a>
    </div>

    <!-- Today's Visits -->
    @if($todayVisits->count() > 0)
    <div class="bg-white rounded-lg shadow overflow-hidden mb-6">
        <div class="px-6 py-4 border-b">
            <h2 class="text-lg font-semibold">Today's Team Visits</h2>
        </div>
        <div class="divide-y">
            @foreach($todayVisits as $visit)
            <div class="px-6 py-4 hover:bg-gray-50">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="flex items-center">
                            <span class="status-badge status-{{ $visit->status }}">
                                {{ ucfirst($visit->status) }}
                            </span>
                            <h3 class="ml-3 font-medium">{{ $visit->client->name }}</h3>
                        </div>
                        <div class="mt-2 flex items-center text-sm text-gray-600">
                            <i class="fas fa-user mr-2"></i>
                            {{ $visit->employee->name }}
                            <span class="mx-2">•</span>
                            <i class="fas fa-clock mr-2"></i>
                            {{ \Carbon\Carbon::parse($visit->scheduled_time)->format('h:i A') }}
                            <span class="mx-2">•</span>
                            <i class="fas fa-map-marker-alt mr-2"></i>
                            {{ $visit->client->governorate->name_en }}
                        </div>
                    </div>
                    <div>
                        @if($visit->status == 'started')
                        <a href="{{ route('supervisor.tracking.show', $visit) }}" 
                           class="btn btn-primary btn-sm">
                            <i class="fas fa-map-marker-alt mr-1"></i> Track Live
                        </a>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Team Status -->
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold mb-4">Team Status</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            @foreach($teamMembers as $member)
            <div class="border rounded-lg p-4 hover:bg-gray-50">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-600">
                        {{ substr($member->name, 0, 1) }}
                    </div>
                    <div class="ml-3">
                        <h4 class="font-medium">{{ $member->name }}</h4>
                        <p class="text-sm text-gray-600">{{ $member->department->name ?? 'N/A' }}</p>
                    </div>
                </div>
                <div class="mt-3 text-sm">
                    <span class="inline-flex items-center">
                        @if($member->todayAttendance && $member->todayAttendance->check_in)
                        <i class="fas fa-check-circle text-green-500 mr-2"></i>
                        <span class="text-green-600">Checked in</span>
                        @else
                        <i class="fas fa-times-circle text-red-500 mr-2"></i>
                        <span class="text-red-600">Not checked in</span>
                        @endif
                    </span>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection