@extends('layouts.dashboard')

@section('title', 'User Details')

@section('content')
<div class="container mx-auto px-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">User Details</h1>
        <div class="flex space-x-2">
            <a href="{{ route('users.edit', $user) }}" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded flex items-center">
                <i class="fas fa-edit mr-2"></i> Edit User
            </a>
            <a href="{{ route('users.index') }}" class="bg-gray-600 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded flex items-center">
                <i class="fas fa-arrow-left mr-2"></i> Back to Users
            </a>
        </div>
    </div>

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="p-6">
            <!-- Profile Header -->
            <div class="flex items-center border-b pb-6 mb-6">
                <div class="flex-shrink-0 h-24 w-24">
                    <div class="h-24 w-24 rounded-full bg-blue-600 flex items-center justify-center text-white text-3xl">
                        @if($user->profile_picture)
                            <img src="{{ Storage::url($user->profile_picture) }}" 
                                 alt="{{ $user->name }}" 
                                 class="h-24 w-24 rounded-full">
                        @else
                            <i class="fas fa-user"></i>
                        @endif
                    </div>
                </div>
                <div class="ml-6">
                    <h2 class="text-2xl font-bold text-gray-900">{{ $user->name }}</h2>
                    <p class="text-gray-600">{{ $user->email }}</p>
                    <div class="flex items-center mt-2">
                        <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full 
                            {{ $user->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            <i class="fas fa-circle mr-1 {{ $user->status == 'active' ? 'text-green-500' : 'text-red-500' }}"></i>
                            {{ ucfirst($user->status) }}
                        </span>
                        <span class="ml-3 px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                            <i class="fas fa-id-card mr-1"></i> {{ $user->employee_id ?? 'N/A' }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- User Information Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Personal Information -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-user-circle mr-2"></i> Personal Information
                    </h3>
                    <div class="space-y-3">
                        <div>
                            <label class="text-sm font-medium text-gray-600">Full Name</label>
                            <p class="text-gray-900">{{ $user->name }}</p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Email Address</label>
                            <p class="text-gray-900">{{ $user->email }}</p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Phone Number</label>
                            <p class="text-gray-900">{{ $user->phone ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Address</label>
                            <p class="text-gray-900">{{ $user->address ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Hire Date</label>
                            <p class="text-gray-900">{{ $user->hire_date ? $user->hire_date->format('Y-m-d') : 'N/A' }}</p>
                        </div>
                    </div>
                </div>

                <!-- Work Information -->
                <div class="bg-gray-50 rounded-lg p-4">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-briefcase mr-2"></i> Work Information
                    </h3>
                    <div class="space-y-3">
                        <div>
                            <label class="text-sm font-medium text-gray-600">Employee ID</label>
                            <p class="text-gray-900">{{ $user->employee_id ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Department</label>
                            <p class="text-gray-900">
                                @if($user->department)
                                    <span class="flex items-center">
                                        <i class="fas fa-building mr-2"></i> {{ $user->department->name }}
                                    </span>
                                @else
                                    N/A
                                @endif
                            </p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Supervisor</label>
                            <p class="text-gray-900">
                                @if($user->supervisor)
                                    <span class="flex items-center">
                                        <i class="fas fa-user-tie mr-2"></i> {{ $user->supervisor->name }}
                                    </span>
                                @else
                                    N/A
                                @endif
                            </p>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">User Roles</label>
                            <div class="flex flex-wrap gap-1 mt-1">
                                @foreach($user->getRoleNames() as $roleName)
                                    <span class="px-2 py-1 inline-flex text-xs leading-4 font-semibold rounded-full 
                                        {{ $roleName == 'admin' ? 'bg-purple-100 text-purple-800 border border-purple-200' : 
                                           ($roleName == 'supervisor' ? 'bg-blue-100 text-blue-800 border border-blue-200' : 
                                           'bg-green-100 text-green-800 border border-green-200') }}">
                                        <i class="fas fa-shield-alt mr-1"></i> {{ ucfirst($roleName) }}
                                    </span>
                                @endforeach
                            </div>
                        </div>
                        <div>
                            <label class="text-sm font-medium text-gray-600">Account Status</label>
                            <p class="text-gray-900">
                                <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full 
                                    {{ $user->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                    {{ ucfirst($user->status) }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Information -->
            <div class="mt-6 bg-gray-50 rounded-lg p-4">
                <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center">
                    <i class="fas fa-info-circle mr-2"></i> Additional Information
                </h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label class="text-sm font-medium text-gray-600">Created At</label>
                        <p class="text-gray-900">{{ $user->created_at->format('Y-m-d H:i:s') }}</p>
                    </div>
                    <div>
                        <label class="text-sm font-medium text-gray-600">Last Updated</label>
                        <p class="text-gray-900">{{ $user->updated_at->format('Y-m-d H:i:s') }}</p>
                    </div>
                    <div>
                        <label class="text-sm font-medium text-gray-600">Last Login</label>
                        <p class="text-gray-900">{{ $user->last_login_at ? $user->last_login_at->format('Y-m-d H:i:s') : 'Never' }}</p>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="mt-8 flex justify-end space-x-3">
                @if($user->status == 'active')
                <form action="{{ route('users.deactivate', $user) }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" 
                            class="bg-yellow-600 hover:bg-yellow-700 text-white font-bold py-2 px-4 rounded flex items-center"
                            onclick="return confirm('Are you sure you want to deactivate this user?')">
                        <i class="fas fa-user-slash mr-2"></i> Deactivate User
                    </button>
                </form>
                @else
                <form action="{{ route('users.activate', $user) }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" 
                            class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded flex items-center"
                            onclick="return confirm('Are you sure you want to activate this user?')">
                        <i class="fas fa-user-check mr-2"></i> Activate User
                    </button>
                </form>
                @endif
                
                <form action="{{ route('users.destroy', $user) }}" method="POST" class="inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" 
                            class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded flex items-center"
                            onclick="return confirm('Are you sure you want to delete this user? This action cannot be undone.')">
                        <i class="fas fa-trash mr-2"></i> Delete User
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection