@extends('layouts.dashboard')

@section('title', 'Visit Management')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Visit Management</h1>
            <p class="text-gray-600 mt-1">Schedule, track, and manage field visits</p>
        </div>
        <div class="flex items-center space-x-3 mt-4 md:mt-0">
            <div class="relative">
                <input type="search" 
                       placeholder="Search visits..." 
                       class="pl-10 pr-4 py-2.5 w-full md:w-64 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                <i class="fas fa-search absolute left-3.5 top-3.5 text-gray-400"></i>
            </div>
            <a href="{{ route('visits.create') }}" 
               class="inline-flex items-center px-4 py-2.5 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition duration-200 shadow-sm hover:shadow-md">
                <i class="fas fa-plus-circle mr-2"></i> Schedule Visit
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-5 mb-8">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-xl bg-blue-50 text-blue-600">
                    <i class="fas fa-calendar-alt text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Scheduled</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">
                        {{ \App\Models\Visit::where('status', 'scheduled')->count() }}
                    </p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <span class="text-xs font-medium text-blue-600 bg-blue-50 px-2 py-1 rounded-full">
                    <i class="fas fa-clock mr-1"></i> Upcoming
                </span>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-xl bg-amber-50 text-amber-600">
                    <i class="fas fa-spinner text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">In Progress</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">
                        {{ \App\Models\Visit::where('status', 'in_progress')->count() }}
                    </p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <span class="text-xs font-medium text-amber-600 bg-amber-50 px-2 py-1 rounded-full">
                    <i class="fas fa-play mr-1"></i> Active
                </span>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-xl bg-emerald-50 text-emerald-600">
                    <i class="fas fa-check-circle text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Completed</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">
                        {{ \App\Models\Visit::where('status', 'completed')->count() }}
                    </p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <span class="text-xs font-medium text-emerald-600 bg-emerald-50 px-2 py-1 rounded-full">
                    <i class="fas fa-check mr-1"></i> Finished
                </span>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-xl bg-red-50 text-red-600">
                    <i class="fas fa-times-circle text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Cancelled</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">
                        {{ \App\Models\Visit::where('status', 'cancelled')->count() }}
                    </p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <span class="text-xs font-medium text-red-600 bg-red-50 px-2 py-1 rounded-full">
                    <i class="fas fa-ban mr-1"></i> Cancelled
                </span>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 mb-6">
        <div class="flex flex-wrap items-center gap-4">
            <div>
                <select class="px-4 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200 bg-white">
                    <option>All Status</option>
                    <option>Scheduled</option>
                    <option>In Progress</option>
                    <option>Completed</option>
                    <option>Cancelled</option>
                </select>
            </div>
            
            <div>
                <select class="px-4 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200 bg-white">
                    <option>All Employees</option>
                    @foreach(\App\Models\User::role('employee')->get() as $employee)
                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                    @endforeach
                </select>
            </div>
            
            <div>
                <input type="date" class="px-4 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200 bg-white" placeholder="From Date">
            </div>
            
            <div>
                <input type="date" class="px-4 py-2.5 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200 bg-white" placeholder="To Date">
            </div>
            
            <button class="inline-flex items-center px-4 py-2.5 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition duration-200">
                <i class="fas fa-filter mr-2"></i> Filter
            </button>
            
            <button class="inline-flex items-center px-4 py-2.5 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition duration-200">
                <i class="fas fa-redo mr-2"></i> Reset
            </button>
        </div>
    </div>

    <!-- Visits Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-calendar mr-2"></i> Date & Time
                            </div>
                        </th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-handshake mr-2"></i> Client
                            </div>
                        </th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-user-tie mr-2"></i> Employee
                            </div>
                        </th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-map-marker-alt mr-2"></i> Location
                            </div>
                        </th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-info-circle mr-2"></i> Status
                            </div>
                        </th>
                        <th class="px-6 py-3.5 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-cog mr-2"></i> Actions
                            </div>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($visits as $visit)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex flex-col">
                                <div class="text-sm font-medium text-gray-900 flex items-center">
                                    <i class="fas fa-calendar-day text-gray-400 mr-2 text-sm"></i>
                                    {{ $visit->scheduled_date->format('M d, Y') }}
                                </div>
                                <div class="text-sm text-gray-500 mt-1 flex items-center">
                                    <i class="fas fa-clock text-gray-400 mr-2 text-sm"></i>
                                    {{ $visit->scheduled_time }}
                                </div>
                                @if($visit->started_at)
                                <div class="text-xs text-blue-600 mt-2 flex items-center bg-blue-50 px-2 py-1 rounded-full w-fit">
                                    <i class="fas fa-play-circle mr-1.5"></i> 
                                    <span class="font-medium">Started:</span> {{ $visit->started_at->format('h:i A') }}
                                </div>
                                @endif
                                @if($visit->completed_at)
                                <div class="text-xs text-emerald-600 mt-1 flex items-center bg-emerald-50 px-2 py-1 rounded-full w-fit">
                                    <i class="fas fa-check-circle mr-1.5"></i> 
                                    <span class="font-medium">Completed:</span> {{ $visit->completed_at->format('h:i A') }}
                                </div>
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="flex-shrink-0">
                                    <div class="h-10 w-10 rounded-xl bg-gradient-to-br from-green-500 to-teal-600 flex items-center justify-center shadow-sm">
                                        <i class="fas fa-handshake text-white"></i>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-semibold text-gray-900">{{ $visit->client->name }}</div>
                                    <div class="text-sm text-gray-500 flex items-center mt-1">
                                        <i class="fas fa-phone-alt text-gray-400 mr-1.5 text-xs"></i>
                                        {{ $visit->client->phone }}
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="flex-shrink-0">
                                    <div class="h-9 w-9 rounded-full bg-gradient-to-br from-blue-500 to-indigo-600 flex items-center justify-center shadow-sm">
                                        <i class="fas fa-user text-white text-xs"></i>
                                    </div>
                                </div>
                                <div class="ml-3">
                                    <div class="text-sm font-medium text-gray-900">{{ $visit->employee->name }}</div>
                                    <div class="text-xs text-gray-500 flex items-center mt-1">
                                        <i class="fas fa-id-card text-gray-400 mr-1.5"></i>
                                        {{ $visit->employee->employee_id }}
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-gray-900">
                                <div class="flex items-center">
                                    <i class="fas fa-map-pin text-gray-400 mr-2"></i>
                                    <span class="font-medium">{{ $visit->area }}, {{ $visit->city->name }}</span>
                                </div>
                                <div class="text-xs text-gray-500 mt-1 ml-6">{{ $visit->governorate->name }}</div>
                                @if($visit->latitude && $visit->longitude)
                                <span class="inline-flex items-center px-2.5 py-1 mt-2 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    <i class="fas fa-map-marked-alt mr-1.5"></i> GPS Enabled
                                </span>
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $statusColors = [
                                    'scheduled' => 'bg-blue-100 text-blue-800',
                                    'in_progress' => 'bg-amber-100 text-amber-800',
                                    'completed' => 'bg-emerald-100 text-emerald-800',
                                    'cancelled' => 'bg-red-100 text-red-800'
                                ];
                                
                                $statusIcons = [
                                    'scheduled' => 'fa-clock',
                                    'in_progress' => 'fa-spinner',
                                    'completed' => 'fa-check-circle',
                                    'cancelled' => 'fa-times-circle'
                                ];
                            @endphp
                            <span class="inline-flex items-center px-3 py-1.5 rounded-full text-sm font-medium {{ $statusColors[$visit->status] }}">
                                <i class="fas {{ $statusIcons[$visit->status] }} mr-1.5"></i>
                                {{ str_replace('_', ' ', ucfirst($visit->status)) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-2">
                                <a href="{{ route('visits.show', $visit) }}" 
                                   class="text-blue-600 hover:text-blue-800 hover:bg-blue-50 p-2 rounded-lg transition-colors duration-200"
                                   title="View Visit">
                                    <i class="fas fa-eye text-sm"></i>
                                </a>
                                <a href="{{ route('visits.edit', $visit) }}" 
                                   class="text-amber-600 hover:text-amber-800 hover:bg-amber-50 p-2 rounded-lg transition-colors duration-200"
                                   title="Edit Visit">
                                    <i class="fas fa-edit text-sm"></i>
                                </a>
                                @if($visit->status == 'scheduled')
                                <form action="{{ route('visits.start', $visit) }}" 
                                      method="POST" 
                                      class="inline">
                                    @csrf
                                    <button type="submit" 
                                            class="text-emerald-600 hover:text-emerald-800 hover:bg-emerald-50 p-2 rounded-lg transition-colors duration-200"
                                            title="Start Visit">
                                        <i class="fas fa-play-circle text-sm"></i>
                                    </button>
                                </form>
                                @endif
                                @if($visit->status == 'in_progress')
                                <button type="button" 
                                        onclick="showCompleteModal({{ $visit->id }})"
                                        class="text-purple-600 hover:text-purple-800 hover:bg-purple-50 p-2 rounded-lg transition-colors duration-200"
                                        title="Complete Visit">
                                    <i class="fas fa-check-circle text-sm"></i>
                                </button>
                                @endif
                                <form action="{{ route('visits.destroy', $visit) }}" 
                                      method="POST" 
                                      class="inline"
                                      onsubmit="return confirmDelete()">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-800 hover:bg-red-50 p-2 rounded-lg transition-colors duration-200"
                                            title="Delete Visit">
                                        <i class="fas fa-trash text-sm"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center">
                            <div class="flex flex-col items-center justify-center">
                                <div class="w-20 h-20 mb-4 text-gray-300">
                                    <i class="fas fa-calendar-times text-5xl"></i>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-700 mb-2">No Visits Found</h3>
                                <p class="text-gray-500 mb-6 max-w-md mx-auto">You haven't scheduled any visits yet. Get started by scheduling your first field visit.</p>
                                <a href="{{ route('visits.create') }}" 
                                   class="inline-flex items-center px-4 py-2.5 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition duration-200 shadow-sm hover:shadow-md">
                                    <i class="fas fa-plus-circle mr-2"></i> Schedule Your First Visit
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($visits->hasPages())
        <div class="bg-gray-50 px-6 py-4 border-t border-gray-100">
            {{ $visits->links() }}
        </div>
        @endif
    </div>
</div>

<!-- Complete Visit Modal -->
<div id="completeModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50 transition-opacity duration-300">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-1/3 shadow-xl rounded-xl bg-white transform transition-transform duration-300">
        <div class="flex justify-between items-center mb-6">
            <div>
                <h3 class="text-lg font-semibold text-gray-900">Complete Visit</h3>
                <p class="text-sm text-gray-600 mt-1">Add completion notes and finish the visit</p>
            </div>
            <button onclick="closeCompleteModal()" 
                    class="text-gray-400 hover:text-gray-600 hover:bg-gray-100 p-2 rounded-lg transition duration-200">
                <i class="fas fa-times text-lg"></i>
            </button>
        </div>
        
        <form id="completeForm" method="POST">
            @csrf
            <div class="mb-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-sticky-note mr-2 text-gray-400"></i>Completion Notes
                </label>
                <textarea name="employee_notes" 
                          rows="4"
                          class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200"
                          placeholder="Add any notes about the visit completion..."></textarea>
            </div>
            
            <div class="flex justify-end space-x-3 pt-4 border-t border-gray-100">
                <button type="button" 
                        onclick="closeCompleteModal()" 
                        class="px-4 py-2.5 border border-gray-300 text-gray-700 font-medium rounded-lg hover:bg-gray-50 transition duration-200">
                    Cancel
                </button>
                <button type="submit" 
                        class="px-4 py-2.5 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition duration-200 shadow-sm hover:shadow-md">
                    <i class="fas fa-check-circle mr-2"></i> Complete Visit
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function confirmDelete() {
    return confirm('Are you sure you want to delete this visit? This action cannot be undone.');
}

function showCompleteModal(visitId) {
    const modal = document.getElementById('completeModal');
    const form = document.getElementById('completeForm');
    
    form.action = `/visits/${visitId}/complete`;
    modal.classList.remove('hidden');
    setTimeout(() => {
        modal.style.opacity = '1';
    }, 10);
}

function closeCompleteModal() {
    const modal = document.getElementById('completeModal');
    modal.style.opacity = '0';
    setTimeout(() => {
        modal.classList.add('hidden');
    }, 300);
}

// Close modal when clicking outside
document.getElementById('completeModal')?.addEventListener('click', function(e) {
    if (e.target.id === 'completeModal') {
        closeCompleteModal();
    }
});

// Search functionality
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.querySelector('input[type="search"]');
    
    searchInput.addEventListener('keyup', function(e) {
        if (e.key === 'Enter') {
            const searchTerm = this.value.trim();
            if (searchTerm) {
                // Implement search functionality here
                console.log('Searching for:', searchTerm);
            }
        }
    });
});
</script>

<style>
/* Custom animations */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

#completeModal > div {
    animation: fadeIn 0.3s ease-out;
}

/* Hover effects for table rows */
tr.hover\:bg-gray-50:hover {
    background-color: #f9fafb;
}
</style>
@endsection