@extends('layouts.dashboard')

@section('title', 'Client Management')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 mb-2">Client Management</h1>
            <p class="text-gray-600">Manage your company clients and their information</p>
        </div>
        <div class="flex items-center space-x-4 mt-4 md:mt-0">
            <div class="relative">
                <input type="search" 
                       placeholder="Search clients..." 
                       class="pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
            </div>
            <a href="{{ route('admin.clients.create') }}" 
               class="inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition duration-200">
                <i class="fas fa-plus-circle mr-2"></i> Add New Client
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-blue-50 text-blue-600">
                    <i class="fas fa-handshake text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Clients</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $clients->total() }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-green-50 text-green-600">
                    <i class="fas fa-check-circle text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Active Clients</p>
                    <p class="text-2xl font-bold text-gray-900">
                        {{ \App\Models\Client::where('status', 'active')->count() }}
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-purple-50 text-purple-600">
                    <i class="fas fa-map-marker-alt text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">With GPS Data</p>
                    <p class="text-2xl font-bold text-gray-900">
                        {{ \App\Models\Client::whereNotNull('latitude')->whereNotNull('longitude')->count() }}
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-yellow-50 text-yellow-600">
                    <i class="fas fa-calendar-check text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Visits</p>
                    <p class="text-2xl font-bold text-gray-900">
                        {{ \App\Models\Visit::count() }}
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Clients Table -->
    <div class="bg-white rounded-lg border border-gray-200 shadow-sm overflow-hidden">
        @if($clients->count() > 0)
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b border-gray-200">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-handshake mr-2"></i> CLIENT
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-map-marker-alt mr-2"></i> LOCATION
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-phone mr-2"></i> CONTACT
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-calendar mr-2"></i> VISITS
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-info-circle mr-2"></i> STATUS
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-cog mr-2"></i> ACTIONS
                            </div>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($clients as $client)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="h-10 w-10 flex-shrink-0">
                                    <div class="h-10 w-10 rounded-lg bg-green-500 flex items-center justify-center">
                                        <i class="fas fa-handshake text-white"></i>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $client->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $client->contact_person ?? 'No contact person' }}</div>
                                    <div class="text-xs text-gray-500">{{ $client->email ?? 'No email' }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-gray-900">
                                <div class="flex items-center">
                                    <i class="fas fa-map-pin text-gray-400 mr-2"></i>
                                    <span>{{ $client->area }}, {{ $client->city->name }}</span>
                                </div>
                                <div class="text-xs text-gray-500 mt-1">{{ $client->governorate->name }}</div>
                                @if($client->latitude && $client->longitude)
                                <span class="inline-flex items-center px-2 py-1 mt-1 rounded text-xs bg-blue-100 text-blue-700">
                                    <i class="fas fa-map-marked-alt mr-1"></i> GPS Enabled
                                </span>
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-gray-900">
                                <div class="flex items-center">
                                    <i class="fas fa-phone text-gray-400 mr-2"></i>
                                    <span>{{ $client->phone }}</span>
                                </div>
                                <div class="text-xs text-gray-500 mt-1">{{ $client->address ?? 'No address' }}</div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex flex-col">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800 mb-1">
                                    <i class="fas fa-calendar-check mr-1"></i>
                                    {{ $client->visits->count() }} visits
                                </span>
                                <div class="text-xs text-gray-500">
                                    Last: {{ $client->visits->first() ? $client->visits->first()->created_at->diffForHumans() : 'No visits' }}
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                                {{ $client->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                <i class="fas fa-circle mr-1 text-{{ $client->status == 'active' ? 'green' : 'red' }}-500" style="font-size: 8px;"></i>
                                {{ ucfirst($client->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center space-x-3">
                                <a href="{{ route('clients.show', $client) }}" 
                                   class="text-blue-600 hover:text-blue-900 transition-colors duration-200"
                                   title="View Client">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('clients.edit', $client) }}" 
                                   class="text-yellow-600 hover:text-yellow-900 transition-colors duration-200"
                                   title="Edit Client">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('clients.destroy', $client) }}" 
                                      method="POST" 
                                      class="inline"
                                      onsubmit="return confirmDelete()">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-900 transition-colors duration-200"
                                            title="Delete Client">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($clients->hasPages())
        <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
            {{ $clients->links() }}
        </div>
        @endif

        @else
        <!-- Empty State -->
        <div class="text-center py-12">
            <div class="w-24 h-24 mx-auto mb-4 text-gray-300">
                <i class="fas fa-handshake text-6xl"></i>
            </div>
            <h3 class="text-lg font-medium text-gray-700 mb-2">No Clients Found</h3>
            <p class="text-gray-500 mb-6">Get started by adding your first client.</p>
            <a href="{{ route('admin.clients.create') }}" 
               class="inline-flex items-center justify-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition duration-200">
                <i class="fas fa-plus-circle mr-2"></i> Add Client
            </a>
        </div>
        @endif
    </div>
</div>

<script>
function confirmDelete() {
    return confirm('Are you sure you want to delete this client? This action cannot be undone.');
}
</script>
@endsection