@extends('layouts.dashboard')

@section('title', $client->name . ' - Client Details')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex items-center justify-between mb-8">
        <div>
            <a href="{{ route('clients.index') }}" 
               class="text-primary-600 hover:text-primary-700 transition-colors duration-200 inline-flex items-center mb-2">
                <i class="fas fa-arrow-left mr-2"></i> Back to Clients
            </a>
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 rounded-lg bg-gradient-to-r from-green-500 to-teal-600 flex items-center justify-center">
                    <i class="fas fa-handshake text-white text-xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">{{ $client->name }}</h1>
                    <div class="flex items-center mt-1 space-x-3">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                            {{ $client->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            <i class="fas fa-circle mr-1 text-{{ $client->status == 'active' ? 'green' : 'red' }}-500" style="font-size: 8px;"></i>
                            {{ ucfirst($client->status) }}
                        </span>
                        <span class="text-sm text-gray-500">
                            <i class="fas fa-calendar mr-1"></i> Created {{ $client->created_at->diffForHumans() }}
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <a href="{{ route('clients.edit', $client) }}" 
               class="btn-primary">
                <i class="fas fa-edit mr-2"></i> Edit Client
            </a>
            @if($client->latitude && $client->longitude)
            <a href="#" 
               onclick="showOnMap()"
               class="btn-secondary">
                <i class="fas fa-map-marked-alt mr-2"></i> View on Map
            </a>
            @endif
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Left Column - Client Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Client Information Card -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
                <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-blue-50 to-blue-100">
                    <h2 class="text-lg font-semibold text-gray-800">Client Information</h2>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 mb-2">Contact Details</h3>
                            <div class="space-y-3">
                                <div class="flex items-center">
                                    <i class="fas fa-user-tie text-gray-400 w-5"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->contact_person ?? 'Not specified' }}</span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-phone text-gray-400 w-5"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->phone }}</span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-envelope text-gray-400 w-5"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->email ?? 'Not specified' }}</span>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <h3 class="text-sm font-medium text-gray-500 mb-2">Location Details</h3>
                            <div class="space-y-3">
                                <div class="flex items-center">
                                    <i class="fas fa-flag text-gray-400 w-5"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->governorate->name }}</span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-city text-gray-400 w-5"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->city->name }}</span>
                                </div>
                                <div class="flex items-center">
                                    <i class="fas fa-map-marker text-gray-400 w-5"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->area }}</span>
                                </div>
                                @if($client->address)
                                <div class="flex items-start">
                                    <i class="fas fa-map-pin text-gray-400 w-5 mt-1"></i>
                                    <span class="ml-3 text-gray-700">{{ $client->address }}</span>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <!-- GPS Coordinates -->
                    @if($client->latitude && $client->longitude)
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <h3 class="text-sm font-medium text-gray-500 mb-2">GPS Coordinates</h3>
                        <div class="flex items-center justify-between bg-gray-50 p-3 rounded-lg">
                            <div>
                                <div class="text-sm text-gray-600">Latitude</div>
                                <div class="font-medium text-gray-800">{{ $client->latitude }}</div>
                            </div>
                            <div>
                                <div class="text-sm text-gray-600">Longitude</div>
                                <div class="font-medium text-gray-800">{{ $client->longitude }}</div>
                            </div>
                            <button onclick="showOnMap()" 
                                    class="btn-secondary">
                                <i class="fas fa-map-marked-alt mr-2"></i> View on Map
                            </button>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Recent Visits Card -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
                <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-purple-50 to-purple-100">
                    <div class="flex items-center justify-between">
                        <h2 class="text-lg font-semibold text-gray-800">Recent Visits</h2>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-purple-100 text-purple-800">
                            <i class="fas fa-calendar-check mr-1"></i>
                            {{ $client->visits->count() }} total visits
                        </span>
                    </div>
                </div>

                <div class="p-6">
                    @if($client->visits->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Date & Time
                                        </th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Employee
                                        </th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Status
                                        </th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Duration
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($client->visits as $visit)
                                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $visit->scheduled_date->format('M d, Y') }}
                                            </div>
                                            <div class="text-sm text-gray-500">
                                                {{ $visit->scheduled_time }}
                                            </div>
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <div class="flex items-center">
                                                <div class="flex-shrink-0 h-8 w-8">
                                                    <div class="h-8 w-8 rounded-full bg-gradient-to-r from-blue-400 to-blue-500 flex items-center justify-center">
                                                        <i class="fas fa-user text-white text-xs"></i>
                                                    </div>
                                                </div>
                                                <div class="ml-3">
                                                    <div class="text-sm font-medium text-gray-900">{{ $visit->employee->name }}</div>
                                                    <div class="text-xs text-gray-500">{{ $visit->employee->employee_id }}</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            @php
                                                $statusColors = [
                                                    'scheduled' => 'bg-yellow-100 text-yellow-800',
                                                    'in_progress' => 'bg-blue-100 text-blue-800',
                                                    'completed' => 'bg-green-100 text-green-800',
                                                    'cancelled' => 'bg-red-100 text-red-800'
                                                ];
                                            @endphp
                                            <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium {{ $statusColors[$visit->status] }}">
                                                {{ str_replace('_', ' ', ucfirst($visit->status)) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">
                                            @if($visit->started_at && $visit->completed_at)
                                                {{ $visit->started_at->diff($visit->completed_at)->format('%H:%I') }}
                                            @else
                                                --
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        @if($client->visits->count() > 5)
                        <div class="mt-4 text-center">
                            <a href="#" class="text-primary-600 hover:text-primary-700 font-medium">
                                View all {{ $client->visits->count() }} visits →
                            </a>
                        </div>
                        @endif
                    @else
                        <div class="text-center py-8">
                            <div class="w-20 h-20 mx-auto mb-4 text-gray-300">
                                <i class="fas fa-calendar-times text-5xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-700 mb-2">No Visits Yet</h3>
                            <p class="text-gray-500 mb-6">No visits have been scheduled for this client yet.</p>
                            <a href="{{ route('visits.create') }}?client_id={{ $client->id }}" 
                               class="btn-primary inline-flex items-center">
                                <i class="fas fa-calendar-plus mr-2"></i> Schedule Visit
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column - Stats & Actions -->
        <div class="space-y-6">
            <!-- Quick Stats -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Client Stats</h2>
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-blue-100 flex items-center justify-center mr-3">
                                <i class="fas fa-calendar-check text-blue-600"></i>
                            </div>
                            <span class="text-sm font-medium text-gray-700">Total Visits</span>
                        </div>
                        <span class="text-xl font-bold text-blue-600">{{ $client->visits->count() }}</span>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-green-100 flex items-center justify-center mr-3">
                                <i class="fas fa-check-circle text-green-600"></i>
                            </div>
                            <span class="text-sm font-medium text-gray-700">Completed</span>
                        </div>
                        <span class="text-xl font-bold text-green-600">
                            {{ $client->visits()->where('status', 'completed')->count() }}
                        </span>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 bg-purple-50 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-purple-100 flex items-center justify-center mr-3">
                                <i class="fas fa-clock text-purple-600"></i>
                            </div>
                            <span class="text-sm font-medium text-gray-700">Scheduled</span>
                        </div>
                        <span class="text-xl font-bold text-purple-600">
                            {{ $client->visits()->where('status', 'scheduled')->count() }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Client Information -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Client Information</h2>
                <div class="space-y-3">
                    <div>
                        <span class="text-sm text-gray-500 block">Created On</span>
                        <span class="text-sm font-medium text-gray-800">{{ $client->created_at->format('F d, Y') }}</span>
                    </div>
                    <div>
                        <span class="text-sm text-gray-500 block">Last Updated</span>
                        <span class="text-sm font-medium text-gray-800">{{ $client->updated_at->format('F d, Y') }}</span>
                    </div>
                    <div>
                        <span class="text-sm text-gray-500 block">Client ID</span>
                        <span class="text-sm font-medium text-gray-800">{{ $client->id }}</span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h2>
                <div class="space-y-3">
                    <a href="{{ route('clients.edit', $client) }}" 
                       class="w-full btn-primary text-center justify-center">
                        <i class="fas fa-edit mr-2"></i> Edit Client
                    </a>
                    <a href="{{ route('visits.create') }}?client_id={{ $client->id }}" 
                       class="w-full btn-secondary text-center justify-center">
                        <i class="fas fa-calendar-plus mr-2"></i> Schedule Visit
                    </a>
                    @if($client->visits()->count() == 0)
                    <form action="{{ route('clients.destroy', $client) }}" 
                          method="POST"
                          onsubmit="return confirmDelete()">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="w-full btn-danger justify-center">
                            <i class="fas fa-trash mr-2"></i> Delete Client
                        </button>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Map View -->
<div id="mapModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-xl bg-white">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-gray-800">{{ $client->name }} - Location</h3>
            <button onclick="closeMap()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>
        <div id="modalMap" class="h-96 rounded-lg border border-gray-300"></div>
        <div class="mt-4 flex justify-end">
            <button onclick="closeMap()" class="btn-secondary">
                Close
            </button>
        </div>
    </div>
</div>

<!-- Leaflet JS for Maps -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
let modalMap = null;

function showOnMap() {
    const modal = document.getElementById('mapModal');
    modal.classList.remove('hidden');
    
    // Initialize map if not already done
    if (!modalMap) {
        const lat = parseFloat("{{ $client->latitude ?? 30.0444 }}");
        const lng = parseFloat("{{ $client->longitude ?? 31.2357 }}");
        
        modalMap = L.map('modalMap').setView([lat, lng], 15);
        
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(modalMap);
        
        // Add marker for client location
        L.marker([lat, lng])
            .addTo(modalMap)
            .bindPopup('{{ $client->name }}<br>{{ $client->address ?? $client->area }}')
            .openPopup();
    }
}

function closeMap() {
    document.getElementById('mapModal').classList.add('hidden');
}

function confirmDelete() {
    return confirm('Are you sure you want to delete this client? This action cannot be undone.');
}
</script>

<style>
#modalMap { 
    height: 100%; 
    width: 100%;
    border-radius: 0.5rem;
}
</style>
@endsection