@extends('layouts.dashboard')

@section('title', 'Supervisor Dashboard')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Welcome Message -->
    <div class="bg-gradient-to-r from-blue-500 to-purple-600 rounded-xl shadow-md p-6 mb-6 text-white">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold mb-2">Welcome back, Supervisor!</h1>
                <p class="opacity-90">Manage your team's visits and approve leave requests</p>
            </div>
            <div class="w-16 h-16 rounded-full bg-white/20 flex items-center justify-center">
                <i class="fas fa-user-tie text-2xl"></i>
            </div>
        </div>
    </div>

    <!-- Team Stats -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                    <i class="fas fa-users text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Team Members</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['team_members'] ?? 0 }}</p>
                </div>
            </div>
        </div>

        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600">
                    <i class="fas fa-calendar-alt text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Scheduled Visits</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['scheduled_visits'] ?? 0 }}</p>
                </div>
            </div>
        </div>

        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600">
                    <i class="fas fa-check-circle text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Completed Today</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['completed_today'] ?? 0 }}</p>
                </div>
            </div>
        </div>

        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600">
                    <i class="fas fa-calendar-times text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Pending Leaves</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['pending_leaves'] ?? 0 }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Two Column Layout -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Team Members -->
        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="px-6 py-4 border-b border-gray-100">
                <h2 class="text-lg font-semibold text-gray-800">Team Members</h2>
            </div>
            <div class="p-6">
                @php
                    $teamMembers = auth()->user()->subordinates()->withCount(['visits' => function($query) {
                        $query->whereDate('scheduled_date', today());
                    }])->get();
                @endphp
                
                @if($teamMembers->count() > 0)
                    <div class="space-y-4">
                        @foreach($teamMembers as $member)
                        <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-r from-blue-400 to-blue-500 flex items-center justify-center">
                                    <i class="fas fa-user text-white"></i>
                                </div>
                                <div class="ml-3">
                                    <div class="font-medium text-gray-900">{{ $member->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $member->employee_id }}</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-sm font-medium text-gray-900">{{ $member->visits_count }} visits today</div>
                                <div class="text-xs text-gray-500">
                                    @if($member->status == 'active')
                                        <span class="text-green-600">Active</span>
                                    @else
                                        <span class="text-red-600">Inactive</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-users text-gray-300 text-4xl mb-3"></i>
                        <p class="text-gray-500">No team members assigned yet</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Today's Visits -->
        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="px-6 py-4 border-b border-gray-100">
                <h2 class="text-lg font-semibold text-gray-800">Today's Visits</h2>
            </div>
            <div class="p-6">
                @php
                    $todaysVisits = auth()->user()->assignedVisits()
                        ->whereDate('scheduled_date', today())
                        ->with('client')
                        ->latest()
                        ->take(5)
                        ->get();
                @endphp
                
                @if($todaysVisits->count() > 0)
                    <div class="space-y-4">
                        @foreach($todaysVisits as $visit)
                        <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg">
                            <div>
                                <div class="font-medium text-gray-900">{{ $visit->client->name }}</div>
                                <div class="text-sm text-gray-500">{{ $visit->scheduled_time }}</div>
                            </div>
                            <div class="text-right">
                                @php
                                    $statusColors = [
                                        'scheduled' => 'bg-yellow-100 text-yellow-800',
                                        'in_progress' => 'bg-blue-100 text-blue-800',
                                        'completed' => 'bg-green-100 text-green-800',
                                        'cancelled' => 'bg-red-100 text-red-800'
                                    ];
                                @endphp
                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium {{ $statusColors[$visit->status] }}">
                                    {{ str_replace('_', ' ', ucfirst($visit->status)) }}
                                </span>
                            </div>
                        </div>
                        @endforeach
                        
                        <div class="text-center pt-4">
                            <a href="{{ route('visits.index') }}" class="text-primary-600 hover:text-primary-700 font-medium">
                                View all visits →
                            </a>
                        </div>
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-calendar-times text-gray-300 text-4xl mb-3"></i>
                        <p class="text-gray-500">No visits scheduled for today</p>
                        <a href="{{ route('visits.create') }}" class="btn-primary mt-3 inline-flex items-center">
                            <i class="fas fa-plus-circle mr-2"></i> Schedule Visit
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="mt-6 bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <a href="{{ route('visits.create') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center mb-3">
                    <i class="fas fa-calendar-plus text-blue-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Schedule Visit</span>
                <span class="text-sm text-gray-500 mt-1">Assign new visit</span>
            </a>
            
            <a href="{{ route('visits.index') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center mb-3">
                    <i class="fas fa-map-marker-alt text-green-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">View Visits</span>
                <span class="text-sm text-gray-500 mt-1">All team visits</span>
            </a>
            
            <a href="{{ route('leaves.index') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-yellow-100 flex items-center justify-center mb-3">
                    <i class="fas fa-calendar-check text-yellow-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Leave Requests</span>
                <span class="text-sm text-gray-500 mt-1">Approve/Reject</span>
            </a>
            
            <a href="{{ route('admin.reports.index') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center mb-3">
                    <i class="fas fa-chart-bar text-purple-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Team Reports</span>
                <span class="text-sm text-gray-500 mt-1">Performance analytics</span>
            </a>
        </div>
    </div>
</div>
@endsection