@extends('layouts.dashboard')

@section('title', 'Admin Dashboard')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Welcome Message -->
    <div class="bg-gradient-to-r from-blue-600 to-purple-700 rounded-xl shadow-md p-6 mb-6 text-white">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold mb-2">Welcome back, Administrator!</h1>
                <p class="opacity-90">Manage your organization's operations and monitor performance</p>
            </div>
            <div class="w-16 h-16 rounded-full bg-white/20 flex items-center justify-center">
                <i class="fas fa-crown text-2xl"></i>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                    <i class="fas fa-users text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Employees</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['total_employees'] }}</p>
                </div>
            </div>
        </div>

        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600">
                    <i class="fas fa-user-tie text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Supervisors</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['total_supervisors'] }}</p>
                </div>
            </div>
        </div>

        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600">
                    <i class="fas fa-handshake text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Clients</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['total_clients'] }}</p>
                </div>
            </div>
        </div>

        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600">
                    <i class="fas fa-calendar-alt text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Pending Visits</p>
                    <p class="text-2xl font-bold text-gray-800">{{ $stats['pending_visits'] }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Recent Visits -->
        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="px-6 py-4 border-b border-gray-100">
                <h2 class="text-lg font-semibold text-gray-800">Recent Visits</h2>
            </div>
            <div class="p-6">
                @php
                    $recentVisits = \App\Models\Visit::with(['employee', 'client'])
                        ->latest()
                        ->take(5)
                        ->get();
                @endphp
                
                @if($recentVisits->count() > 0)
                    <div class="space-y-4">
                        @foreach($recentVisits as $visit)
                        <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-r from-blue-400 to-blue-500 flex items-center justify-center">
                                    <i class="fas fa-user text-white text-sm"></i>
                                </div>
                                <div class="ml-3">
                                    <div class="font-medium text-gray-900">{{ $visit->employee->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $visit->client->name }}</div>
                                </div>
                            </div>
                            <div class="text-right">
                                <div class="text-sm font-medium text-gray-900">{{ $visit->scheduled_date->format('M d') }}</div>
                                <div class="text-xs text-gray-500">{{ $visit->scheduled_time }}</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    
                    <div class="mt-4 text-center">
                        <a href="{{ route('visits.index') }}" class="text-primary-600 hover:text-primary-700 font-medium">
                            View all visits →
                        </a>
                    </div>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-calendar-times text-gray-300 text-4xl mb-3"></i>
                        <p class="text-gray-500">No recent visits</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- System Overview -->
        <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
            <div class="px-6 py-4 border-b border-gray-100">
                <h2 class="text-lg font-semibold text-gray-800">System Overview</h2>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center">
                                <i class="fas fa-building text-blue-600"></i>
                            </div>
                            <div class="ml-3">
                                <div class="font-medium text-gray-900">Departments</div>
                                <div class="text-sm text-gray-500">Active departments</div>
                            </div>
                        </div>
                        <div class="text-2xl font-bold text-gray-800">
                            {{ \App\Models\Department::where('status', 'active')->count() }}
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center">
                                <i class="fas fa-map-marker-alt text-green-600"></i>
                            </div>
                            <div class="ml-3">
                                <div class="font-medium text-gray-900">Active Visits</div>
                                <div class="text-sm text-gray-500">Visits in progress</div>
                            </div>
                        </div>
                        <div class="text-2xl font-bold text-gray-800">
                            {{ \App\Models\Visit::where('status', 'in_progress')->count() }}
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full bg-yellow-100 flex items-center justify-center">
                                <i class="fas fa-calendar-times text-yellow-600"></i>
                            </div>
                            <div class="ml-3">
                                <div class="font-medium text-gray-900">Pending Leaves</div>
                                <div class="text-sm text-gray-500">Awaiting approval</div>
                            </div>
                        </div>
                        <div class="text-2xl font-bold text-gray-800">{{ $stats['pending_leaves'] }}</div>
                    </div>
                    
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full bg-purple-100 flex items-center justify-center">
                                <i class="fas fa-chart-line text-purple-600"></i>
                            </div>
                            <div class="ml-3">
                                <div class="font-medium text-gray-900">Today's Activity</div>
                                <div class="text-sm text-gray-500">Visits completed today</div>
                            </div>
                        </div>
                        <div class="text-2xl font-bold text-gray-800">{{ $stats['completed_visits'] }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="mt-6 bg-white rounded-xl shadow-sm border border-gray-100 p-6">
        <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <a href="{{ route('admin.users.create') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-blue-100 flex items-center justify-center mb-3">
                    <i class="fas fa-user-plus text-blue-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Add User</span>
                <span class="text-sm text-gray-500 mt-1">Create new employee</span>
            </a>
            
            <a href="{{ route('admin.clients.create') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-green-100 flex items-center justify-center mb-3">
                    <i class="fas fa-handshake text-green-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Add Client</span>
                <span class="text-sm text-gray-500 mt-1">Register new client</span>
            </a>
            
            <a href="{{ route('visits.create') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-purple-100 flex items-center justify-center mb-3">
                    <i class="fas fa-calendar-plus text-purple-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Schedule Visit</span>
                <span class="text-sm text-gray-500 mt-1">Assign new visit</span>
            </a>
            
            <a href="{{ route('admin.reports.index') }}" class="flex flex-col items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition duration-200">
                <div class="w-12 h-12 rounded-full bg-yellow-100 flex items-center justify-center mb-3">
                    <i class="fas fa-chart-bar text-yellow-600 text-xl"></i>
                </div>
                <span class="font-medium text-gray-900">Reports</span>
                <span class="text-sm text-gray-500 mt-1">View analytics</span>
            </a>
        </div>
    </div>
</div>
@endsection