@extends('layouts.dashboard')

@section('title', 'Edit Department')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex items-center justify-between mb-8">
        <div>
            <a href="{{ route('admin.departments.index') }}" 
               class="text-primary-600 hover:text-primary-700 transition-colors duration-200 inline-flex items-center mb-2">
                <i class="fas fa-arrow-left mr-2"></i> Back to Departments
            </a>
            <h1 class="text-2xl font-bold text-gray-800">Edit Department</h1>
            <p class="text-gray-600 mt-1">Update department information</p>
        </div>
        <div class="flex items-center space-x-2">
            <div class="w-12 h-12 rounded-lg bg-gradient-to-r from-yellow-100 to-yellow-200 flex items-center justify-center">
                <i class="fas fa-edit text-yellow-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <!-- Form Header -->
            <div class="px-6 py-4 border-b border-gray-100 bg-gradient-to-r from-yellow-50 to-yellow-100">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-gray-800">Edit {{ $department->name }}</h2>
                        <p class="text-sm text-gray-600 mt-1">Update the department details</p>
                    </div>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                        {{ $department->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                        <i class="fas fa-circle mr-1 text-{{ $department->status == 'active' ? 'green' : 'red' }}-500" style="font-size: 8px;"></i>
                        {{ ucfirst($department->status) }}
                    </span>
                </div>
            </div>

            <!-- Form -->
            <form action="{{ route('departments.update', $department) }}" method="POST" class="p-6">
                @csrf
                @method('PUT')

                <div class="space-y-6">
                    <!-- Department Name -->
                    <div>
                        <label for="name" class="form-label">
                            <i class="fas fa-tag mr-2 text-gray-400"></i>Department Name *
                        </label>
                        <input type="text" 
                               id="name" 
                               name="name" 
                               value="{{ old('name', $department->name) }}"
                               class="form-input @error('name') border-red-500 @enderror"
                               placeholder="e.g., Sales, Marketing, IT"
                               required>
                        @error('name')
                            <p class="mt-1 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                            </p>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div>
                        <label for="description" class="form-label">
                            <i class="fas fa-align-left mr-2 text-gray-400"></i>Description
                        </label>
                        <textarea id="description" 
                                  name="description" 
                                  rows="4"
                                  class="form-input @error('description') border-red-500 @enderror"
                                  placeholder="Brief description about the department's role and responsibilities...">{{ old('description', $department->description) }}</textarea>
                        @error('description')
                            <p class="mt-1 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                            </p>
                        @enderror
                        <div class="flex justify-between items-center mt-1">
                            <p class="text-sm text-gray-500">Optional description for the department</p>
                            <span id="charCount" class="text-xs text-gray-400">{{ strlen($department->description) }} characters</span>
                        </div>
                    </div>

                    <!-- Status -->
                    <div>
                        <label for="status" class="form-label">
                            <i class="fas fa-power-off mr-2 text-gray-400"></i>Status *
                        </label>
                        <select id="status" 
                                name="status" 
                                class="form-select @error('status') border-red-500 @enderror"
                                required>
                            <option value="active" {{ old('status', $department->status) == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ old('status', $department->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                        @error('status')
                            <p class="mt-1 text-sm text-red-600 flex items-center">
                                <i class="fas fa-exclamation-circle mr-1"></i> {{ $message }}
                            </p>
                        @enderror
                        <div class="mt-2 space-y-2">
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full bg-green-500 mr-2"></div>
                                <span class="text-sm text-gray-600">Active: Department is operational and visible</span>
                            </div>
                            <div class="flex items-center">
                                <div class="w-3 h-3 rounded-full bg-red-500 mr-2"></div>
                                <span class="text-sm text-gray-600">Inactive: Department is archived and not visible in assignments</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Footer -->
                <div class="mt-8 pt-6 border-t border-gray-100 flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">
                            <i class="fas fa-info-circle mr-1"></i> Fields marked with * are required
                        </p>
                    </div>
                    <div class="flex items-center space-x-3">
                        <a href="{{ route('admin.departments.index') }}" 
                           class="btn-secondary">
                            <i class="fas fa-times mr-2"></i> Cancel
                        </a>
                        <button type="submit" 
                                class="btn-primary">
                            <i class="fas fa-save mr-2"></i> Update Department
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Danger Zone -->
        <div class="mt-6 bg-red-50 border border-red-100 rounded-lg p-4">
            <div class="flex">
                <div class="flex-shrink-0">
                    <i class="fas fa-exclamation-triangle text-red-500 text-lg"></i>
                </div>
                <div class="ml-3">
                    <h3 class="text-sm font-medium text-red-800">Danger Zone</h3>
                    <div class="mt-2">
                        <p class="text-sm text-red-700 mb-3">
                            Deleting this department will permanently remove it from the system. 
                            @if($department->users()->count() > 0)
                            <span class="font-semibold">Cannot delete: This department has {{ $department->users()->count() }} employees.</span>
                            @endif
                        </p>
                        @if($department->users()->count() == 0)
                        <form action="{{ route('departments.destroy', $department) }}" 
                              method="POST" 
                              onsubmit="return confirmDelete()">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="btn-danger inline-flex items-center">
                                <i class="fas fa-trash mr-2"></i> Delete Department
                            </button>
                        </form>
                        @else
                        <button type="button" 
                                class="btn-secondary cursor-not-allowed opacity-50 inline-flex items-center"
                                disabled>
                            <i class="fas fa-trash mr-2"></i> Delete Department (Disabled)
                        </button>
                        <p class="text-xs text-red-600 mt-2">
                            <i class="fas fa-info-circle mr-1"></i> Reassign all employees to other departments first
                        </p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete() {
    return confirm('Are you sure you want to delete this department? This action cannot be undone.');
}

// Character counter for description
document.addEventListener('DOMContentLoaded', function() {
    const description = document.getElementById('description');
    const charCount = document.getElementById('charCount');
    
    if (description && charCount) {
        description.addEventListener('input', function() {
            charCount.textContent = this.value.length + ' characters';
        });
    }
});
</script>
@endsection