@extends('layouts.dashboard')

@section('title', $department->name . ' - Department Details')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex items-center justify-between mb-8">
        <div>
            <a href="{{ route('admin.departments.index') }}" 
               class="text-primary-600 hover:text-primary-700 transition-colors duration-200 inline-flex items-center mb-2">
                <i class="fas fa-arrow-left mr-2"></i> Back to Departments
            </a>
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 rounded-lg bg-gradient-to-r from-blue-500 to-blue-600 flex items-center justify-center">
                    <i class="fas fa-building text-white text-xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">{{ $department->name }}</h1>
                    <div class="flex items-center mt-1 space-x-3">
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                            {{ $department->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            <i class="fas fa-circle mr-1 text-{{ $department->status == 'active' ? 'green' : 'red' }}-500" style="font-size: 8px;"></i>
                            {{ ucfirst($department->status) }}
                        </span>
                        <span class="text-sm text-gray-500">
                            <i class="fas fa-calendar mr-1"></i> Created {{ $department->created_at->diffForHumans() }}
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex items-center space-x-2">
            <a href="{{ route('departments.edit', $department) }}" 
               class="btn-primary">
                <i class="fas fa-edit mr-2"></i> Edit Department
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Left Column - Department Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Description Card -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="text-lg font-semibold text-gray-800">Department Description</h2>
                    <i class="fas fa-align-left text-blue-500"></i>
                </div>
                @if($department->description)
                    <p class="text-gray-700 whitespace-pre-line">{{ $department->description }}</p>
                @else
                    <div class="text-center py-8">
                        <i class="fas fa-info-circle text-gray-300 text-4xl mb-3"></i>
                        <p class="text-gray-500">No description provided</p>
                    </div>
                @endif
            </div>

            <!-- Employees Card -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100">
                <div class="px-6 py-4 border-b border-gray-100">
                    <div class="flex items-center justify-between">
                        <h2 class="text-lg font-semibold text-gray-800">Department Employees</h2>
                        <div class="flex items-center">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                <i class="fas fa-users mr-1"></i>
                                {{ $employees->total() }} employees
                            </span>
                        </div>
                    </div>
                </div>

                <div class="p-6">
                    @if($employees->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Employee
                                        </th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Role
                                        </th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Status
                                        </th>
                                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Hire Date
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach($employees as $employee)
                                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <div class="flex items-center">
                                                <div class="flex-shrink-0 h-8 w-8">
                                                    <div class="h-8 w-8 rounded-full bg-gradient-to-r from-blue-400 to-blue-500 flex items-center justify-center">
                                                        <i class="fas fa-user text-white text-xs"></i>
                                                    </div>
                                                </div>
                                                <div class="ml-3">
                                                    <div class="text-sm font-medium text-gray-900">{{ $employee->name }}</div>
                                                    <div class="text-xs text-gray-500">{{ $employee->employee_id }}</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            @foreach($employee->roles as $role)
                                                <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium 
                                                    {{ $role->name == 'admin' ? 'bg-purple-100 text-purple-800' : 
                                                       ($role->name == 'supervisor' ? 'bg-blue-100 text-blue-800' : 'bg-green-100 text-green-800') }}">
                                                    {{ ucfirst($role->name) }}
                                                </span>
                                            @endforeach
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium 
                                                {{ $employee->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                {{ ucfirst($employee->status) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">
                                            {{ $employee->hire_date ? $employee->hire_date->format('M d, Y') : 'N/A' }}
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        @if($employees->hasPages())
                        <div class="mt-4">
                            {{ $employees->links() }}
                        </div>
                        @endif
                    @else
                        <div class="text-center py-8">
                            <div class="w-20 h-20 mx-auto mb-4 text-gray-300">
                                <i class="fas fa-users text-5xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-700 mb-2">No Employees</h3>
                            <p class="text-gray-500 mb-6">No employees are assigned to this department yet.</p>
                            <a href="{{ route('admin.users.create') }}" 
                               class="btn-primary inline-flex items-center">
                                <i class="fas fa-user-plus mr-2"></i> Add New Employee
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column - Stats & Actions -->
        <div class="space-y-6">
            <!-- Quick Stats -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Department Stats</h2>
                <div class="space-y-4">
                    <div class="flex items-center justify-between p-3 bg-blue-50 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-blue-100 flex items-center justify-center mr-3">
                                <i class="fas fa-users text-blue-600"></i>
                            </div>
                            <span class="text-sm font-medium text-gray-700">Total Employees</span>
                        </div>
                        <span class="text-xl font-bold text-blue-600">{{ $employees->total() }}</span>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 bg-green-50 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-green-100 flex items-center justify-center mr-3">
                                <i class="fas fa-user-check text-green-600"></i>
                            </div>
                            <span class="text-sm font-medium text-gray-700">Active Employees</span>
                        </div>
                        <span class="text-xl font-bold text-green-600">
                            {{ $department->users()->where('status', 'active')->count() }}
                        </span>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 bg-purple-50 rounded-lg">
                        <div class="flex items-center">
                            <div class="w-8 h-8 rounded-full bg-purple-100 flex items-center justify-center mr-3">
                                <i class="fas fa-user-tie text-purple-600"></i>
                            </div>
                            <span class="text-sm font-medium text-gray-700">Supervisors</span>
                        </div>
                        <span class="text-xl font-bold text-purple-600">
                            {{ $department->users()->whereHas('roles', function($q) {
                                $q->where('name', 'supervisor');
                            })->count() }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Department Information -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Department Information</h2>
                <div class="space-y-3">
                    <div>
                        <span class="text-sm text-gray-500 block">Created On</span>
                        <span class="text-sm font-medium text-gray-800">{{ $department->created_at->format('F d, Y') }}</span>
                    </div>
                    <div>
                        <span class="text-sm text-gray-500 block">Last Updated</span>
                        <span class="text-sm font-medium text-gray-800">{{ $department->updated_at->format('F d, Y') }}</span>
                    </div>
                    <div>
                        <span class="text-sm text-gray-500 block">Department ID</span>
                        <span class="text-sm font-medium text-gray-800">{{ $department->id }}</span>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card-hover bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h2>
                <div class="space-y-3">
                    <a href="{{ route('departments.edit', $department) }}" 
                       class="w-full btn-secondary text-center justify-center">
                        <i class="fas fa-edit mr-2"></i> Edit Department
                    </a>
                    <a href="{{ route('admin.users.create') }}" 
                       class="w-full btn-primary text-center justify-center">
                        <i class="fas fa-user-plus mr-2"></i> Add Employee
                    </a>
                    @if($department->users()->count() == 0)
                    <form action="{{ route('departments.destroy', $department) }}" 
                          method="POST"
                          onsubmit="return confirmDelete()">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="w-full btn-danger justify-center">
                            <i class="fas fa-trash mr-2"></i> Delete Department
                        </button>
                    </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete() {
    return confirm('Are you sure you want to delete this department? This action cannot be undone.');
}
</script>
@endsection