@extends('layouts.dashboard')

@section('title', 'Employee Dashboard')

@section('styles')
<style>
    .stat-card {
        transition: all 0.3s ease;
    }
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }
    .visit-item {
        border-left: 4px solid transparent;
        transition: all 0.2s ease;
    }
    .visit-item:hover {
        background-color: #f9fafb;
        border-left-color: #3b82f6;
    }
</style>
@endsection

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Welcome Banner -->
    <div class="bg-gradient-to-r from-blue-500 to-purple-600 rounded-xl shadow-lg p-6 mb-8 text-white">
        <div class="flex flex-col md:flex-row justify-between items-center">
            <div class="flex items-center mb-4 md:mb-0">
                <div class="mr-4">
                    <img src="{{ $user->avatar_url }}" alt="{{ $user->name }}" 
                         class="w-16 h-16 rounded-full border-4 border-white/30">
                </div>
                <div>
                    <h1 class="text-2xl md:text-3xl font-bold">Welcome back, {{ $user->name }}!</h1>
                    <p class="text-blue-100 mt-1">
                        <i class="fas fa-id-badge mr-1"></i>{{ $user->full_employee_id }}
                        @if($user->department)
                        • <i class="fas fa-building ml-2 mr-1"></i>{{ $user->department->name }}
                        @endif
                    </p>
                </div>
            </div>
            <div class="text-center md:text-right">
                <div class="text-3xl font-bold">{{ now()->format('h:i A') }}</div>
                <div class="text-blue-100">{{ now()->format('l, F j, Y') }}</div>
                @if($user->is_on_visit)
                <div class="mt-2 px-3 py-1 bg-yellow-500/20 rounded-full inline-block">
                    <i class="fas fa-map-marker-alt mr-1"></i> Currently on a visit
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-xl shadow p-6 stat-card border-l-4 border-blue-500">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600 mr-4">
                    <i class="fas fa-map-marker-alt text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Active Visits</p>
                    <h3 class="text-2xl font-bold text-gray-800">{{ $activeVisits }}</h3>
                </div>
            </div>
            <a href="{{ route('visits.index', ['status' => 'in_progress']) }}" 
               class="mt-4 inline-block text-blue-600 hover:text-blue-800 text-sm font-medium">
                View active visits <i class="fas fa-arrow-right ml-1"></i>
            </a>
        </div>

        <div class="bg-white rounded-xl shadow p-6 stat-card border-l-4 border-green-500">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-green-100 text-green-600 mr-4">
                    <i class="fas fa-check-circle text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Completed Visits</p>
                    <h3 class="text-2xl font-bold text-gray-800">{{ $completedVisits }}</h3>
                </div>
            </div>
            <a href="{{ route('visits.index', ['status' => 'completed']) }}" 
               class="mt-4 inline-block text-green-600 hover:text-green-800 text-sm font-medium">
                View history <i class="fas fa-arrow-right ml-1"></i>
            </a>
        </div>

        <div class="bg-white rounded-xl shadow p-6 stat-card border-l-4 border-yellow-500">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-yellow-100 text-yellow-600 mr-4">
                    <i class="fas fa-calendar-alt text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Leave Balance</p>
                    <h3 class="text-2xl font-bold text-gray-800">{{ $approvedLeaves }}/{{ $pendingLeaves + $approvedLeaves }}</h3>
                    <p class="text-xs text-gray-500 mt-1">
                        <span class="text-green-600">{{ $approvedLeaves }} approved</span> • 
                        <span class="text-yellow-600">{{ $pendingLeaves }} pending</span>
                    </p>
                </div>
            </div>
            <a href="{{ route('leaves.index') }}" 
               class="mt-4 inline-block text-yellow-600 hover:text-yellow-800 text-sm font-medium">
                Manage leaves <i class="fas fa-arrow-right ml-1"></i>
            </a>
        </div>

        <div class="bg-white rounded-xl shadow p-6 stat-card border-l-4 border-purple-500">
            <div class="flex items-center">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600 mr-4">
                    <i class="fas fa-satellite text-xl"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Live Tracking</p>
                    <h3 class="text-2xl font-bold text-gray-800">
                        @if($activeVisits > 0) Active @else Ready @endif
                    </h3>
                </div>
            </div>
            <a href="{{ route('live-tracking.map') }}" 
               class="mt-4 inline-block text-purple-600 hover:text-purple-800 text-sm font-medium">
                View map <i class="fas fa-arrow-right ml-1"></i>
            </a>
        </div>
    </div>

    <!-- Two Column Layout -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Current Active Visits -->
        <div class="bg-white rounded-xl shadow">
            <div class="p-6 border-b border-gray-200">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-gray-800">Current Active Visits</h2>
                    @if($currentVisits->count() > 0)
                    <span class="px-3 py-1 bg-blue-100 text-blue-800 text-sm rounded-full">
                        {{ $currentVisits->count() }} active
                    </span>
                    @endif
                </div>
            </div>
            <div class="divide-y divide-gray-200">
                @forelse($currentVisits as $visit)
                <div class="p-6 visit-item">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <div class="flex items-center mb-3">
                                <div class="p-2 rounded-full bg-blue-100 text-blue-600 mr-3">
                                    <i class="fas fa-building"></i>
                                </div>
                                <div>
                                    <h3 class="font-medium text-gray-900">{{ $visit->client->name ?? 'Unknown Client' }}</h3>
                                    <p class="text-sm text-gray-600">{{ $visit->client->area ?? 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="ml-11">
                                <div class="flex items-center text-sm text-gray-600 mb-2">
                                    <i class="fas fa-map-marker-alt w-4 mr-2"></i>
                                    <span class="truncate">{{ $visit->current_address ?? 'Location updating...' }}</span>
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center text-sm text-gray-500">
                                        <i class="fas fa-clock w-4 mr-2"></i>
                                        <span>Started {{ $visit->started_at ? $visit->started_at->diffForHumans() : 'Recently' }}</span>
                                    </div>
                                    <div class="flex space-x-2">
                                        <a href="{{ route('gps.track', $visit) }}" 
                                           class="px-3 py-1 bg-blue-600 hover:bg-blue-700 text-white text-sm rounded-lg transition">
                                            <i class="fas fa-satellite mr-1"></i> Track
                                        </a>
                                        <a href="{{ route('visits.show', $visit) }}" 
                                           class="px-3 py-1 bg-gray-100 hover:bg-gray-200 text-gray-700 text-sm rounded-lg transition">
                                            <i class="fas fa-eye mr-1"></i> View
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="p-8 text-center">
                    <div class="p-3 rounded-full bg-gray-100 text-gray-400 inline-block mb-4">
                        <i class="fas fa-map-marker-alt text-2xl"></i>
                    </div>
                    <p class="text-gray-600">No active visits</p>
                    <p class="text-sm text-gray-500 mt-1">Start a new visit to begin tracking</p>
                    <a href="{{ route('visits.create') }}" 
                       class="mt-4 inline-block px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg">
                        <i class="fas fa-plus mr-1"></i> Start New Visit
                    </a>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Upcoming Visits -->
        <div class="bg-white rounded-xl shadow">
            <div class="p-6 border-b border-gray-200">
                <div class="flex justify-between items-center">
                    <h2 class="text-xl font-semibold text-gray-800">Upcoming Visits</h2>
                    <a href="{{ route('visits.index', ['status' => 'pending']) }}" 
                       class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                        View All <i class="fas fa-arrow-right ml-1"></i>
                    </a>
                </div>
            </div>
            <div class="divide-y divide-gray-200">
                @forelse($upcomingVisits as $visit)
                <div class="p-6 visit-item">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <div class="flex items-center mb-3">
                                <div class="p-2 rounded-full bg-yellow-100 text-yellow-600 mr-3">
                                    <i class="fas fa-calendar-alt"></i>
                                </div>
                                <div>
                                    <h3 class="font-medium text-gray-900">{{ $visit->client->name ?? 'Unknown Client' }}</h3>
                                    <p class="text-sm text-gray-600">{{ $visit->client->area ?? 'N/A' }}</p>
                                </div>
                            </div>
                            <div class="ml-11">
                                <div class="flex items-center text-sm text-gray-600 mb-2">
                                    <i class="fas fa-clock w-4 mr-2"></i>
                                    <span>{{ $visit->scheduled_date ? $visit->scheduled_date->format('D, M j, Y') : 'Not scheduled' }}</span>
                                    @if($visit->scheduled_time)
                                    <span class="mx-2">•</span>
                                    <span>{{ $visit->scheduled_time }}</span>
                                    @endif
                                </div>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center text-sm text-gray-500">
                                        <i class="fas fa-user-tie w-4 mr-2"></i>
                                        <span>{{ $visit->client->contact_person ?? 'No contact' }}</span>
                                    </div>
                                    <div class="flex space-x-2">
                                        @if($visit->status === 'pending')
                                        <form action="{{ route('visits.start', $visit) }}" method="POST" class="inline">
                                            @csrf
                                            <button type="submit" 
                                                    class="px-3 py-1 bg-green-600 hover:bg-green-700 text-white text-sm rounded-lg transition"
                                                    onclick="return confirm('Start this visit now?')">
                                                <i class="fas fa-play mr-1"></i> Start
                                            </button>
                                        </form>
                                        @endif
                                        <a href="{{ route('visits.show', $visit) }}" 
                                           class="px-3 py-1 bg-gray-100 hover:bg-gray-200 text-gray-700 text-sm rounded-lg transition">
                                            <i class="fas fa-eye mr-1"></i> Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="p-8 text-center">
                    <div class="p-3 rounded-full bg-gray-100 text-gray-400 inline-block mb-4">
                        <i class="fas fa-calendar-times text-2xl"></i>
                    </div>
                    <p class="text-gray-600">No upcoming visits scheduled</p>
                    <p class="text-sm text-gray-500 mt-1">Check back later or contact your supervisor</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Recent Completed Visits -->
    <div class="bg-white rounded-xl shadow mb-8">
        <div class="p-6 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-800">Recent Completed Visits</h2>
                <a href="{{ route('visits.index', ['status' => 'completed']) }}" 
                   class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                    View All <i class="fas fa-arrow-right ml-1"></i>
                </a>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Client</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date & Time</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Duration</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($recentVisits as $visit)
                    <tr class="hover:bg-gray-50 transition">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="flex-shrink-0 h-8 w-8">
                                    <div class="h-8 w-8 rounded-full bg-green-100 flex items-center justify-center text-green-600">
                                        <i class="fas fa-building"></i>
                                    </div>
                                </div>
                                <div class="ml-3">
                                    <div class="text-sm font-medium text-gray-900">{{ $visit->client->name ?? 'Unknown' }}</div>
                                    <div class="text-xs text-gray-500">{{ $visit->client->area ?? 'N/A' }}</div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                {{ $visit->completed_at ? $visit->completed_at->format('M d, Y') : 'N/A' }}
                            </div>
                            <div class="text-xs text-gray-500">
                                {{ $visit->completed_at ? $visit->completed_at->format('h:i A') : 'N/A' }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                @if($visit->started_at && $visit->completed_at)
                                    {{ $visit->started_at->diffInHours($visit->completed_at) }}h 
                                    {{ $visit->started_at->diffInMinutes($visit->completed_at) % 60 }}m
                                @else
                                    N/A
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                <i class="fas fa-check-circle mr-1"></i> Completed
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <a href="{{ route('visits.show', $visit) }}" class="text-blue-600 hover:text-blue-900 mr-3">
                                <i class="fas fa-eye"></i> View
                            </a>
                            <a href="{{ route('gps.route-history', $visit) }}" class="text-purple-600 hover:text-purple-900">
                                <i class="fas fa-route"></i> Route
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            <div class="flex flex-col items-center">
                                <i class="fas fa-history text-4xl text-gray-300 mb-3"></i>
                                <p>No completed visits yet</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white rounded-xl shadow p-6">
        <h2 class="text-xl font-semibold mb-6 text-gray-800">Quick Actions</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <a href="{{ route('visits.create') }}" 
               class="bg-blue-50 hover:bg-blue-100 border border-blue-200 rounded-lg p-4 text-center transition duration-200">
                <div class="p-3 rounded-full bg-blue-100 text-blue-600 inline-block mb-3">
                    <i class="fas fa-plus-circle text-xl"></i>
                </div>
                <h3 class="font-medium text-gray-800">Start New Visit</h3>
                <p class="text-sm text-gray-600 mt-1">Begin tracking a client visit</p>
            </a>

            <a href="{{ route('leaves.create') }}" 
               class="bg-green-50 hover:bg-green-100 border border-green-200 rounded-lg p-4 text-center transition duration-200">
                <div class="p-3 rounded-full bg-green-100 text-green-600 inline-block mb-3">
                    <i class="fas fa-calendar-plus text-xl"></i>
                </div>
                <h3 class="font-medium text-gray-800">Request Leave</h3>
                <p class="text-sm text-gray-600 mt-1">Submit leave application</p>
            </a>

            <a href="{{ route('live-tracking.map') }}" 
               class="bg-purple-50 hover:bg-purple-100 border border-purple-200 rounded-lg p-4 text-center transition duration-200">
                <div class="p-3 rounded-full bg-purple-100 text-purple-600 inline-block mb-3">
                    <i class="fas fa-satellite text-xl"></i>
                </div>
                <h3 class="font-medium text-gray-800">Live Tracking</h3>
                <p class="text-sm text-gray-600 mt-1">View real-time location tracking</p>
            </a>

            <a href="{{ route('profile.index') }}" 
               class="bg-gray-50 hover:bg-gray-100 border border-gray-200 rounded-lg p-4 text-center transition duration-200">
                <div class="p-3 rounded-full bg-gray-100 text-gray-600 inline-block mb-3">
                    <i class="fas fa-user-cog text-xl"></i>
                </div>
                <h3 class="font-medium text-gray-800">My Profile</h3>
                <p class="text-sm text-gray-600 mt-1">Update your profile information</p>
            </a>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-refresh page every 60 seconds if there are active visits
    @if($activeVisits > 0)
    setTimeout(function() {
        window.location.reload();
    }, 60000); // 60 seconds
    @endif
});
</script>
@endsection