<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    @php
        $appName = config('settings.app_name', 'Innovaxcess Attendance');
        $favicon = config('settings.favicon');
        $logo = config('settings.logo');
        $theme = config('settings.theme', 'light');
        $primaryColor = config('settings.primary_color', '#3b82f6');
        $secondaryColor = config('settings.secondary_color', '#6b7280');
        
        // Get stats for dashboard
        $stats = [
            'totalDepartments' => \App\Models\Department::count(),
            'totalUsers' => \App\Models\User::count(),
            'activeUsers' => \App\Models\User::where('status', 'active')->count(),
            'inactiveUsers' => \App\Models\User::where('status', 'inactive')->count(),
            'totalClients' => \App\Models\Client::count(),
            'totalVisits' => \App\Models\Visit::count(),
            'completedVisits' => \App\Models\Visit::where('status', 'completed')->count(),
            'pendingVisits' => \App\Models\Visit::where('status', 'pending')->count(),
            'pendingLeaves' => \App\Models\LeaveRequest::where('status', 'pending')->count(),
            'approvedLeaves' => \App\Models\LeaveRequest::where('status', 'approved')->count(),
            'rejectedLeaves' => \App\Models\LeaveRequest::where('status', 'rejected')->count(),
            'totalPayrolls' => \App\Models\Payroll::count(),
            'processedPayrolls' => \App\Models\Payroll::where('status', 'completed')->count(),
        ];
        
        // Data for pie charts
        $userStatusData = [
            ['status' => 'Active', 'count' => $stats['activeUsers'], 'color' => '#10B981'],
            ['status' => 'Inactive', 'count' => $stats['inactiveUsers'], 'color' => '#EF4444']
        ];
        
        $visitStatusData = [
            ['status' => 'Completed', 'count' => $stats['completedVisits'], 'color' => '#10B981'],
            ['status' => 'Pending', 'count' => $stats['pendingVisits'], 'color' => '#F59E0B']
        ];
        
        $leaveStatusData = [
            ['status' => 'Approved', 'count' => $stats['approvedLeaves'], 'color' => '#10B981'],
            ['status' => 'Pending', 'count' => $stats['pendingLeaves'], 'color' => '#F59E0B'],
            ['status' => 'Rejected', 'count' => $stats['rejectedLeaves'], 'color' => '#EF4444']
        ];
    @endphp

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Innovaxcess Attendance')</title>

    @if($favicon)
    <link rel="icon" href="{{ Storage::url($favicon) }}" type="image/x-icon">
    @endif

    <!-- PWA Meta Tags -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Innovaxcess">
    <link rel="apple-touch-icon" href="{{ $favicon ? Storage::url($favicon) : '/images/icon-192x192.png' }}">

    <!-- Manifest -->
    <link rel="manifest" href="/manifest.json">

    <!-- Theme Color -->
    <meta name="theme-color" content="{{ $primaryColor }}">
    <meta name="msapplication-TileColor" content="{{ $primaryColor }}">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Chart.js for Pie Charts -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '{{ $primaryColor }}10',
                            100: '{{ $primaryColor }}20',
                            200: '{{ $primaryColor }}30',
                            300: '{{ $primaryColor }}40',
                            400: '{{ $primaryColor }}50',
                            500: '{{ $primaryColor }}',
                            600: '{{ $primaryColor }}70',
                            700: '{{ $primaryColor }}80',
                            800: '{{ $primaryColor }}90',
                            900: '{{ $primaryColor }}95',
                        },
                        secondary: {
                            500: '{{ $secondaryColor }}',
                        }
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-in': 'slideIn 0.3s ease-out'
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' }
                        },
                        slideIn: {
                            '0%': { transform: 'translateY(-10px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' }
                        }
                    }
                }
            }
        }
    </script>

    <!-- Custom CSS -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <link href="{{ asset('css/custom.css') }}" rel="stylesheet">
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <!-- Additional Custom CSS -->
    <style>
        .sidebar-transition {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .card-hover {
            transition: all 0.3s ease-in-out;
        }
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        .gradient-text {
            background: linear-gradient(135deg, {{ $primaryColor }} 0%, {{ $secondaryColor }} 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        /* Sidebar custom styles */
        .sidebar-item {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 0.75rem;
        }
        
        .sidebar-item:hover {
            background: linear-gradient(135deg, rgba(59, 130, 246, 0.1) 0%, rgba(59, 130, 246, 0.05) 100%);
            transform: translateX(5px);
        }
        
        .sidebar-item.active {
            background: linear-gradient(135deg, {{ $primaryColor }} 0%, rgba(59, 130, 246, 0.8) 100%);
            color: white !important;
            box-shadow: 0 4px 6px -1px rgba(59, 130, 246, 0.2), 0 2px 4px -1px rgba(59, 130, 246, 0.1);
        }
        
        .sidebar-item.active i {
            color: white !important;
        }
        
        .sidebar-item:hover i {
            transform: scale(1.1);
        }
        
        /* Colorful icons */
        .icon-dashboard { color: #3b82f6; }
        .icon-users { color: #10b981; }
        .icon-departments { color: #8b5cf6; }
        .icon-clients { color: #f59e0b; }
        .icon-visits { color: #ef4444; }
        .icon-tracking { color: #06b6d4; }
        .icon-leaves { color: #84cc16; }
        .icon-payroll { color: #f97316; }
        .icon-reports { color: #8b5cf6; }
        .icon-settings { color: #64748b; }
        
        /* Logo glow effect */
        .logo-glow {
            filter: drop-shadow(0 4px 6px rgba(59, 130, 246, 0.2));
            transition: filter 0.3s ease;
        }
        
        .logo-glow:hover {
            filter: drop-shadow(0 8px 15px rgba(59, 130, 246, 0.3));
        }
        
        /* Sticky sidebar */
        .sticky-sidebar {
            position: sticky;
            top: 0;
            height: 100vh;
            overflow-y: auto;
        }
        
        /* Sticky header */
        .sticky-header {
            position: sticky;
            top: 0;
            z-index: 40;
        }
        
        /* Mobile sidebar */
        .mobile-open {
            transform: translateX(0) !important;
        }

        /* Chart container */
        .chart-container {
            position: relative;
            height: 250px;
            width: 100%;
        }
        
        /* Custom scrollbar for sidebar */
        .sidebar-scroll::-webkit-scrollbar {
            width: 4px;
        }
        
        .sidebar-scroll::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }
        
        .sidebar-scroll::-webkit-scrollbar-thumb {
            background: #c1c1c1;
            border-radius: 10px;
        }
        
        .sidebar-scroll::-webkit-scrollbar-thumb:hover {
            background: #a8a8a8;
        }
        
        /* Theme-specific styles */
        @if($theme == 'dark')
        body {
            background-color: #1f2937;
            color: #f9fafb;
        }
        .bg-white {
            background-color: #374151 !important;
        }
        .text-gray-800 {
            color: #f9fafb !important;
        }
        .text-gray-600 {
            color: #d1d5db !important;
        }
        .border-gray-200 {
            border-color: #4b5563 !important;
        }
        .bg-gray-100 {
            background-color: #1f2937 !important;
        }
        @endif
    </style>

    @stack('styles')
</head>
<body class="bg-gray-100 font-sans {{ $theme == 'dark' ? 'dark' : '' }}">
    <div class="flex h-screen" x-data="{ sidebarOpen: false }">
        <!-- Sidebar - Sticky from logo -->
        <div class="sidebar bg-white text-gray-900 w-64 absolute inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition duration-200 ease-in-out z-40 shadow-xl border-r border-gray-200 sticky-sidebar"
            :class="{'mobile-open': sidebarOpen}">
            
            <!-- Logo - Sticky at top -->
            <div class="sticky top-0 bg-white z-10 pb-4 pt-6 px-4 border-b border-gray-200">
                <div class="flex flex-col items-center justify-center">
                    <div class="logo-glow mb-3">
                        <img src="https://image2url.com/images/1765115626698-e3e8ecd8-9dec-4661-a804-d965dd6f556c.png" 
                             alt="Innovaxcess Logo" 
                             class="h-14 w-auto">
                    </div>
                    <div class="text-center">
                        <div class="h-1 w-16 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full mx-auto mb-2"></div>
                        <p class="text-xs text-gray-500 font-medium tracking-wider">ATTENDANCE SYSTEM</p>
                    </div>
                </div>
            </div>

            <!-- Sidebar Navigation - Scrollable content -->
            <nav class="flex-1 p-4 overflow-y-auto sidebar-scroll">
                <ul class="space-y-1">
                    <li>
                        <a href="{{ route('dashboard') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                            <i class="fas fa-tachometer-alt w-5 mr-3 text-lg icon-dashboard transition-transform duration-200"></i>
                            <span class="font-medium">Dashboard</span>
                        </a>
                    </li>
                    
                    @if(auth()->user()->hasRole('admin'))
                    <li>
                        <a href="{{ route('users.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('users.*') ? 'active' : '' }}">
                            <i class="fas fa-users w-5 mr-3 text-lg icon-users transition-transform duration-200"></i>
                            <span class="font-medium">User Management</span>
                        </a>
                    </li>
                    
                    <li>
                        <a href="{{ route('admin.departments.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('departments.*') ? 'active' : '' }}">
                            <i class="fas fa-building w-5 mr-3 text-lg icon-departments transition-transform duration-200"></i>
                            <span class="font-medium">Departments</span>
                        </a>
                    </li>
                    
                    <li>
                        <a href="{{ route('clients.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('clients.*') ? 'active' : '' }}">
                            <i class="fas fa-handshake w-5 mr-3 text-lg icon-clients transition-transform duration-200"></i>
                            <span class="font-medium">Clients</span>
                        </a>
                    </li>
                    @endif
                    
                    <li>
                        <a href="{{ route('visits.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('visits.*') ? 'active' : '' }}">
                            <i class="fas fa-map-marked-alt w-5 mr-3 text-lg icon-visits transition-transform duration-200"></i>
                            <span class="font-medium">Visits</span>
                        </a>
                    </li>
                    
                    <!-- LIVE TRACKING -->
                    <li>
                        <a href="{{ route('live-tracking.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('live-tracking.*') ? 'active' : '' }}">
                            <i class="fas fa-satellite w-5 mr-3 text-lg icon-tracking transition-transform duration-200"></i>
                            <span class="font-medium">Live Tracking</span>
                        </a>
                    </li>
                    
                    <li>
                        <a href="{{ route('leaves.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('leaves.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar-alt w-5 mr-3 text-lg icon-leaves transition-transform duration-200"></i>
                            <span class="font-medium">Leave Management</span>
                        </a>
                    </li>
                    
                    @if(auth()->user()->hasRole('admin'))
                    <li>
                        <a href="{{ route('payrolls.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('payrolls.*') ? 'active' : '' }}">
                            <i class="fas fa-money-check-alt w-5 mr-3 text-lg icon-payroll transition-transform duration-200"></i>
                            <span class="font-medium">Payroll</span>
                        </a>
                    </li>
                    
                    <li>
                        <a href="{{ route('admin.reports.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-bar w-5 mr-3 text-lg icon-reports transition-transform duration-200"></i>
                            <span class="font-medium">Reports</span>
                        </a>
                    </li>
                    
                    <!-- SYSTEM SETTINGS - Added here -->
                    <li>
                        <a href="{{ route('settings.index') }}" 
                           class="sidebar-item flex items-center p-3 {{ request()->routeIs('settings.*') ? 'active' : '' }}">
                            <i class="fas fa-cog w-5 mr-3 text-lg icon-settings transition-transform duration-200"></i>
                            <span class="font-medium">System Settings</span>
                        </a>
                    </li>
                    @endif
                </ul>
                
                <!-- Bottom spacing -->
                <div class="mt-8 pt-4">
                    <!-- Empty space for visual balance -->
                </div>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Header - Sticky -->
            <header class="bg-white shadow-sm border-b border-gray-200 sticky-header">
                <div class="flex items-center justify-between p-4">
                    <div class="flex items-center">
                        <button @click="sidebarOpen = !sidebarOpen" class="md:hidden text-gray-600 hover:text-gray-900 focus:outline-none transition duration-200 mr-3">
                            <i class="fas fa-bars text-xl"></i>
                        </button>
                        <div class="flex items-center">
                            <h1 class="text-xl font-bold text-gray-900">@yield('title', 'Dashboard')</h1>
                            @if(!request()->routeIs('dashboard'))
                            <div class="ml-3 flex items-center text-sm text-gray-500">
                                <i class="fas fa-chevron-right mx-2 text-xs"></i>
                                <span class="text-gray-600">@yield('subtitle', '')</span>
                            </div>
                            @endif
                        </div>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <!-- Date & Time Display -->
                        <div class="hidden md:flex items-center space-x-2 bg-gray-50 px-3 py-1.5 rounded-lg">
                            <i class="fas fa-calendar-alt text-blue-600 text-sm"></i>
                            <span class="text-sm font-medium text-gray-700" id="currentDate">{{ now()->format('F d, Y') }}</span>
                        </div>
                        
                        <div class="hidden md:flex items-center space-x-2 bg-gray-50 px-3 py-1.5 rounded-lg">
                            <i class="fas fa-clock text-green-600 text-sm"></i>
                            <span class="text-sm font-medium text-gray-700" id="currentTime">{{ now()->format('h:i A') }}</span>
                        </div>
                        
                        <!-- Notifications -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="relative p-2 text-gray-600 hover:text-gray-900 hover:bg-gray-100 rounded-full transition duration-200">
                                <i class="fas fa-bell text-lg"></i>
                                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-500"></span>
                            </button>
                            
                            <!-- Notifications Dropdown -->
                            <div x-show="open" @click.away="open = false" 
                                class="absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-lg z-50 border border-gray-200"
                                x-transition:enter="transition ease-out duration-100"
                                x-transition:enter-start="transform opacity-0 scale-95"
                                x-transition:enter-end="transform opacity-100 scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="transform opacity-100 scale-100"
                                x-transition:leave-end="transform opacity-0 scale-95">
                                <div class="p-4 border-b border-gray-200">
                                    <h3 class="font-semibold text-gray-900">Notifications</h3>
                                    <p class="text-xs text-gray-500">You have 3 new notifications</p>
                                </div>
                                <div class="max-h-64 overflow-y-auto">
                                    <a href="#" class="flex items-center px-4 py-3 hover:bg-gray-50 border-b border-gray-100">
                                        <div class="flex-shrink-0">
                                            <div class="w-8 h-8 rounded-full bg-blue-100 flex items-center justify-center">
                                                <i class="fas fa-user-plus text-blue-600 text-sm"></i>
                                            </div>
                                        </div>
                                        <div class="ml-3 flex-1">
                                            <p class="text-sm text-gray-900">New user registered</p>
                                            <p class="text-xs text-gray-500">2 minutes ago</p>
                                        </div>
                                    </a>
                                    <a href="#" class="flex items-center px-4 py-3 hover:bg-gray-50 border-b border-gray-100">
                                        <div class="flex-shrink-0">
                                            <div class="w-8 h-8 rounded-full bg-green-100 flex items-center justify-center">
                                                <i class="fas fa-check-circle text-green-600 text-sm"></i>
                                            </div>
                                        </div>
                                        <div class="ml-3 flex-1">
                                            <p class="text-sm text-gray-900">Visit completed successfully</p>
                                            <p class="text-xs text-gray-500">1 hour ago</p>
                                        </div>
                                    </a>
                                    <a href="#" class="flex items-center px-4 py-3 hover:bg-gray-50">
                                        <div class="flex-shrink-0">
                                            <div class="w-8 h-8 rounded-full bg-yellow-100 flex items-center justify-center">
                                                <i class="fas fa-exclamation-triangle text-yellow-600 text-sm"></i>
                                            </div>
                                        </div>
                                        <div class="ml-3 flex-1">
                                            <p class="text-sm text-gray-900">System maintenance scheduled</p>
                                            <p class="text-xs text-gray-500">Yesterday</p>
                                        </div>
                                    </a>
                                </div>
                                <div class="p-3 border-t border-gray-200">
                                    <a href="#" class="block text-center text-sm text-blue-600 hover:text-blue-800 font-medium">
                                        View all notifications
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- User Profile - Moved to Header -->
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" 
                                    class="flex items-center space-x-3 p-2 hover:bg-gray-100 rounded-lg transition duration-200 focus:outline-none">
                                <div class="flex-shrink-0">
                                    <div class="w-9 h-9 rounded-full bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center text-white shadow">
                                        <i class="fas fa-user text-sm"></i>
                                    </div>
                                </div>
                                <div class="hidden md:block text-left">
                                    <p class="text-sm font-medium text-gray-900 truncate max-w-[120px]">{{ Auth::user()->name }}</p>
                                    <p class="text-xs text-gray-500 truncate max-w-[120px]">{{ Auth::user()->getRoleNames()->first() ?? 'User' }}</p>
                                </div>
                                <i class="fas fa-chevron-down text-gray-400 text-xs hidden md:block"></i>
                            </button>
                            
                            <!-- User Dropdown Menu -->
                            <div x-show="open" @click.away="open = false" 
                                class="absolute right-0 mt-2 w-56 bg-white rounded-lg shadow-lg z-50 border border-gray-200"
                                x-transition:enter="transition ease-out duration-100"
                                x-transition:enter-start="transform opacity-0 scale-95"
                                x-transition:enter-end="transform opacity-100 scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="transform opacity-100 scale-100"
                                x-transition:leave-end="transform opacity-0 scale-95">
                                <!-- User Info -->
                                <div class="p-4 border-b border-gray-200">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0">
                                            <div class="w-10 h-10 rounded-full bg-gradient-to-r from-blue-500 to-purple-600 flex items-center justify-center text-white">
                                                <i class="fas fa-user"></i>
                                            </div>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm font-medium text-gray-900">{{ Auth::user()->name }}</p>
                                            <p class="text-xs text-gray-500">{{ Auth::user()->email }}</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Menu Items -->
                                <div class="py-2">
                                    <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-user-edit mr-3 text-gray-400 w-4 text-center"></i>
                                        <span>Edit Profile</span>
                                    </a>
                                    <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-cog mr-3 text-gray-400 w-4 text-center"></i>
                                        <span>Account Settings</span>
                                    </a>
                                    <a href="#" class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <i class="fas fa-shield-alt mr-3 text-gray-400 w-4 text-center"></i>
                                        <span>Privacy & Security</span>
                                    </a>
                                    
                                    <div class="border-t border-gray-100 my-2"></div>
                                    
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="flex items-center w-full px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                            <i class="fas fa-sign-out-alt mr-3 w-4 text-center"></i>
                                            <span>Logout</span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50 p-6">
                @if(session('success'))
                    <div class="bg-green-50 border-l-4 border-green-500 p-4 rounded-lg mb-6 animate-fade-in">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <i class="fas fa-check-circle text-green-500 text-lg"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-green-700 font-medium">{{ session('success') }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                @if(session('error'))
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg mb-6 animate-fade-in">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <i class="fas fa-exclamation-circle text-red-500 text-lg"></i>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm text-red-700 font-medium">{{ session('error') }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                @yield('content')
                
                <!-- Default Dashboard Content -->
                @if(!isset($content) && request()->routeIs('dashboard'))
                
                <!-- SECTION 1: QUICK ACTIONS -->
                <div class="bg-white rounded-xl shadow p-6 mb-8 border border-gray-100">
                    <h2 class="text-xl font-bold mb-6 text-gray-900">Quick Actions</h2>
                    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
                        <a href="{{ route('visits.create') }}" class="bg-gradient-to-br from-blue-50 to-blue-100 hover:from-blue-100 hover:to-blue-200 text-blue-700 p-4 rounded-xl text-center transition-all duration-300 card-hover border border-blue-200">
                            <i class="fas fa-plus-circle text-2xl mb-2"></i>
                            <p class="text-sm font-medium">New Visit</p>
                        </a>
                        <a href="{{ route('leaves.create') }}" class="bg-gradient-to-br from-green-50 to-green-100 hover:from-green-100 hover:to-green-200 text-green-700 p-4 rounded-xl text-center transition-all duration-300 card-hover border border-green-200">
                            <i class="fas fa-calendar-plus text-2xl mb-2"></i>
                            <p class="text-sm font-medium">Request Leave</p>
                        </a>
                        <a href="{{ route('admin.users.create') }}" class="bg-gradient-to-br from-purple-50 to-purple-100 hover:from-purple-100 hover:to-purple-200 text-purple-700 p-4 rounded-xl text-center transition-all duration-300 card-hover border border-purple-200">
                            <i class="fas fa-user-plus text-2xl mb-2"></i>
                            <p class="text-sm font-medium">Add User</p>
                        </a>
                        <a href="{{ route('admin.clients.create') }}" class="bg-gradient-to-br from-orange-50 to-orange-100 hover:from-orange-100 hover:to-orange-200 text-orange-700 p-4 rounded-xl text-center transition-all duration-300 card-hover border border-orange-200">
                            <i class="fas fa-handshake text-2xl mb-2"></i>
                            <p class="text-sm font-medium">Add Client</p>
                        </a>
                        <a href="{{ route('admin.payrolls.create') }}" class="bg-gradient-to-br from-yellow-50 to-yellow-100 hover:from-yellow-100 hover:to-yellow-200 text-yellow-700 p-4 rounded-xl text-center transition-all duration-300 card-hover border border-yellow-200">
                            <i class="fas fa-money-bill-wave text-2xl mb-2"></i>
                            <p class="text-sm font-medium">Create Payroll</p>
                        </a>
                        <a href="{{ route('admin.reports.index') }}" class="bg-gradient-to-br from-red-50 to-red-100 hover:from-red-100 hover:to-red-200 text-red-700 p-4 rounded-xl text-center transition-all duration-300 card-hover border border-red-200">
                            <i class="fas fa-chart-bar text-2xl mb-2"></i>
                            <p class="text-sm font-medium">View Reports</p>
                        </a>
                    </div>
                </div>

                <!-- SECTION 2: DASHBOARD STATISTICS -->
                <div class="bg-white rounded-xl shadow p-6 mb-8 border border-gray-100">
                    <h2 class="text-xl font-bold mb-6 text-gray-900">System Statistics</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl shadow p-6 card-hover border border-blue-200">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm text-gray-600">Total Users</p>
                                    <h3 class="text-2xl font-bold text-gray-900">{{ $stats['totalUsers'] }}</h3>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <span class="text-green-600 font-medium">{{ $stats['activeUsers'] }} active</span> • 
                                        <span class="text-red-600 font-medium">{{ $stats['inactiveUsers'] }} inactive</span>
                                    </p>
                                </div>
                                <div class="p-3 rounded-xl bg-gradient-to-r from-blue-500 to-blue-600 text-white shadow">
                                    <i class="fas fa-users text-xl"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-xl shadow p-6 card-hover border border-green-200">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm text-gray-600">Departments</p>
                                    <h3 class="text-2xl font-bold text-gray-900">{{ $stats['totalDepartments'] }}</h3>
                                    <p class="text-xs text-gray-500 mt-1">Organizational units</p>
                                </div>
                                <div class="p-3 rounded-xl bg-gradient-to-r from-green-500 to-green-600 text-white shadow">
                                    <i class="fas fa-building text-xl"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-xl shadow p-6 card-hover border border-purple-200">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm text-gray-600">Clients</p>
                                    <h3 class="text-2xl font-bold text-gray-900">{{ $stats['totalClients'] }}</h3>
                                    <p class="text-xs text-gray-500 mt-1">Business partners</p>
                                </div>
                                <div class="p-3 rounded-xl bg-gradient-to-r from-purple-500 to-purple-600 text-white shadow">
                                    <i class="fas fa-handshake text-xl"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gradient-to-br from-yellow-50 to-yellow-100 rounded-xl shadow p-6 card-hover border border-yellow-200">
                            <div class="flex items-center justify-between">
                                <div>
                                    <p class="text-sm text-gray-600">Total Visits</p>
                                    <h3 class="text-2xl font-bold text-gray-900">{{ $stats['totalVisits'] }}</h3>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <span class="text-green-600 font-medium">{{ $stats['completedVisits'] }} completed</span> • 
                                        <span class="text-yellow-600 font-medium">{{ $stats['pendingVisits'] }} pending</span>
                                    </p>
                                </div>
                                <div class="p-3 rounded-xl bg-gradient-to-r from-yellow-500 to-yellow-600 text-white shadow">
                                    <i class="fas fa-map-marker-alt text-xl"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- SECTION 3: PIE CHARTS VISUALIZATION -->
                <div class="bg-white rounded-xl shadow p-6 mb-8 border border-gray-100">
                    <h2 class="text-xl font-bold mb-6 text-gray-900">Data Visualization</h2>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- User Status Pie Chart -->
                        <div class="bg-gray-50 rounded-xl p-4 border border-gray-200">
                            <h3 class="font-semibold mb-4 text-gray-700">User Status Distribution</h3>
                            <div class="chart-container">
                                <canvas id="userStatusChart"></canvas>
                            </div>
                            <div class="mt-4 space-y-2">
                                @foreach($userStatusData as $item)
                                <div class="flex items-center justify-between text-sm">
                                    <div class="flex items-center">
                                        <div class="w-3 h-3 rounded-full mr-2" style="background-color: {{ $item['color'] }}"></div>
                                        <span>{{ $item['status'] }}</span>
                                    </div>
                                    <span class="font-medium">{{ $item['count'] }}</span>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        
                        <!-- Visit Status Pie Chart -->
                        <div class="bg-gray-50 rounded-xl p-4 border border-gray-200">
                            <h3 class="font-semibold mb-4 text-gray-700">Visit Status Distribution</h3>
                            <div class="chart-container">
                                <canvas id="visitStatusChart"></canvas>
                            </div>
                            <div class="mt-4 space-y-2">
                                @foreach($visitStatusData as $item)
                                <div class="flex items-center justify-between text-sm">
                                    <div class="flex items-center">
                                        <div class="w-3 h-3 rounded-full mr-2" style="background-color: {{ $item['color'] }}"></div>
                                        <span>{{ $item['status'] }}</span>
                                    </div>
                                    <span class="font-medium">{{ $item['count'] }}</span>
                                </div>
                                @endforeach
                            </div>
                        </div>
                        
                        <!-- Leave Status Pie Chart -->
                        <div class="bg-gray-50 rounded-xl p-4 border border-gray-200">
                            <h3 class="font-semibold mb-4 text-gray-700">Leave Request Status</h3>
                            <div class="chart-container">
                                <canvas id="leaveStatusChart"></canvas>
                            </div>
                            <div class="mt-4 space-y-2">
                                @foreach($leaveStatusData as $item)
                                <div class="flex items-center justify-between text-sm">
                                    <div class="flex items-center">
                                        <div class="w-3 h-3 rounded-full mr-2" style="background-color: {{ $item['color'] }}"></div>
                                        <span>{{ $item['status'] }}</span>
                                    </div>
                                    <span class="font-medium">{{ $item['count'] }}</span>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>

                <!-- SECTION 4: RECENT VISITS -->
                <div class="bg-white rounded-xl shadow p-6 border border-gray-100">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-xl font-bold text-gray-900">Recent Visits</h2>
                        <a href="{{ route('visits.index') }}" class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center">
                            View All <i class="fas fa-arrow-right ml-2 text-xs"></i>
                        </a>
                    </div>
                    <div class="space-y-4">
                        @php
                            $recentVisits = \App\Models\Visit::with(['user', 'client'])
                                ->latest()
                                ->take(8)
                                ->get();
                        @endphp
                        
                        @forelse($recentVisits as $visit)
                        <div class="flex items-center justify-between p-4 bg-gray-50 hover:bg-gray-100 rounded-xl transition duration-200 border border-gray-200">
                            <div class="flex items-center">
                                <div class="p-3 rounded-xl {{ $visit->status == 'completed' ? 'bg-green-100 text-green-600' : 'bg-yellow-100 text-yellow-600' }} mr-4 shadow-sm">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div>
                                    <p class="font-medium text-gray-900">{{ $visit->client->name ?? 'Unknown Client' }}</p>
                                    <p class="text-sm text-gray-600">
                                        <i class="fas fa-user mr-1"></i>{{ $visit->user->name }} • 
                                        <i class="fas fa-calendar ml-2 mr-1"></i>{{ $visit->visit_date->format('M d, Y') }} •
                                        <i class="fas fa-clock ml-2 mr-1"></i>{{ $visit->visit_time }}
                                    </p>
                                </div>
                            </div>
                            <div class="text-right">
                                <span class="px-3 py-1 text-xs rounded-full font-medium {{ $visit->status == 'completed' ? 'bg-green-100 text-green-800' : ($visit->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-blue-100 text-blue-800') }}">
                                    {{ ucfirst($visit->status) }}
                                </span>
                                <p class="text-xs text-gray-500 mt-1">{{ $visit->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                        @empty
                        <div class="text-center py-8">
                            <i class="fas fa-map-marker-alt text-4xl text-gray-300 mb-4"></i>
                            <p class="text-gray-600">No recent visits found.</p>
                            <p class="text-sm text-gray-500 mt-1">Start by creating your first visit.</p>
                        </div>
                        @endforelse
                    </div>
                </div>
                @endif
            </main>
        </div>

        <!-- Mobile sidebar backdrop -->
        <div x-show="sidebarOpen" @click="sidebarOpen = false" 
            class="fixed inset-0 z-20 bg-black bg-opacity-50 md:hidden"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0">
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('sidebar', () => ({
                open: false
            }))
        });

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdowns = document.querySelectorAll('[x-data]');
            dropdowns.forEach(dropdown => {
                if (!dropdown.contains(event.target)) {
                    const openState = dropdown.__x.$data.open;
                    if (openState !== undefined) {
                        dropdown.__x.$data.open = false;
                    }
                }
            });
        });

        // Initialize Pie Charts when page loads
        document.addEventListener('DOMContentLoaded', function() {
            // User Status Chart
            const userCtx = document.getElementById('userStatusChart').getContext('2d');
            const userChart = new Chart(userCtx, {
                type: 'pie',
                data: {
                    labels: ['Active', 'Inactive'],
                    datasets: [{
                        data: [{{ $stats['activeUsers'] }}, {{ $stats['inactiveUsers'] }}],
                        backgroundColor: ['#10B981', '#EF4444'],
                        borderWidth: 2,
                        borderColor: '#fff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.label + ': ' + context.parsed;
                                }
                            }
                        }
                    }
                }
            });

            // Visit Status Chart
            const visitCtx = document.getElementById('visitStatusChart').getContext('2d');
            const visitChart = new Chart(visitCtx, {
                type: 'pie',
                data: {
                    labels: ['Completed', 'Pending'],
                    datasets: [{
                        data: [{{ $stats['completedVisits'] }}, {{ $stats['pendingVisits'] }}],
                        backgroundColor: ['#10B981', '#F59E0B'],
                        borderWidth: 2,
                        borderColor: '#fff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.label + ': ' + context.parsed;
                                }
                            }
                        }
                    }
                }
            });

            // Leave Status Chart
            const leaveCtx = document.getElementById('leaveStatusChart').getContext('2d');
            const leaveChart = new Chart(leaveCtx, {
                type: 'pie',
                data: {
                    labels: ['Approved', 'Pending', 'Rejected'],
                    datasets: [{
                        data: [{{ $stats['approvedLeaves'] }}, {{ $stats['pendingLeaves'] }}, {{ $stats['rejectedLeaves'] }}],
                        backgroundColor: ['#10B981', '#F59E0B', '#EF4444'],
                        borderWidth: 2,
                        borderColor: '#fff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.label + ': ' + context.parsed;
                                }
                            }
                        }
                    }
                }
            });

            // Update time every minute
            function updateTime() {
                const now = new Date();
                const timeElement = document.getElementById('currentTime');
                const dateElement = document.getElementById('currentDate');
                
                if (timeElement) {
                    timeElement.textContent = now.toLocaleTimeString('en-US', { 
                        hour: 'numeric', 
                        minute: '2-digit',
                        hour12: true 
                    });
                }
                
                if (dateElement) {
                    dateElement.textContent = now.toLocaleDateString('en-US', { 
                        weekday: 'long', 
                        year: 'numeric', 
                        month: 'long', 
                        day: 'numeric' 
                    });
                }
            }
            
            updateTime();
            setInterval(updateTime, 60000);
        });
    </script>
    
    <!-- Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('/sw.js')
                    .then(function(registration) {
                        console.log('ServiceWorker registration successful with scope: ', registration.scope);
                    })
                    .catch(function(error) {
                        console.log('ServiceWorker registration failed: ', error);
                    });
            });
        }
    </script>
</body>
</html>